/*
 JSZip v3.1.5 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/master/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/master/LICENSE
*/
'use strict';(function(ca){"object"===typeof exports&&"undefined"!==typeof module?module.exports=ca():"function"===typeof define&&define.amd?define([],ca):("undefined"!==typeof window?window:"undefined"!==typeof global?global:"undefined"!==typeof self?self:this).JSZip=ca()})(function(){return function h(l,H,y){function q(r,u){if(!H[r]){if(!l[r]){var m="function"==typeof require&&require;if(!u&&m)return m(r,!0);if(d)return d(r,!0);u=Error("Cannot find module '"+r+"'");throw u.code="MODULE_NOT_FOUND",
u;}u=H[r]={exports:{}};l[r][0].call(u.exports,function(x){var f=l[r][1][x];return q(f?f:x)},u,u.exports,h,l,H,y)}return H[r].exports}for(var d="function"==typeof require&&require,n=0;n<y.length;n++)q(y[n]);return q}({1:[function(l,H,y){var h=l("./utils"),q=l("./support");y.encode=function(d){for(var n=[],r,u,m,x,f=0,k=d.length,t,C="string"!==h.getTypeOf(d);f<d.length;)t=k-f,C?(r=d[f++],u=f<k?d[f++]:0,m=f<k?d[f++]:0):(r=d.charCodeAt(f++),u=f<k?d.charCodeAt(f++):0,m=f<k?d.charCodeAt(f++):0),x=r>>2,
r=(r&3)<<4|u>>4,u=1<t?(u&15)<<2|m>>6:64,m=2<t?m&63:64,n.push("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(x)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(r)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(u)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(m));return n.join("")};y.decode=function(d){var n=0,r=0;if("data:"===d.substr(0,5))throw Error("Invalid base64 input, it looks like a data url.");
d=d.replace(/[^A-Za-z0-9\+\/=]/g,"");var u=3*d.length/4;"="===d.charAt(d.length-1)&&u--;"="===d.charAt(d.length-2)&&u--;if(0!==u%1)throw Error("Invalid base64 input, bad content length.");var m;for(m=q.uint8array?new Uint8Array(u|0):Array(u|0);n<d.length;){var x="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(d.charAt(n++));var f="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(d.charAt(n++));u="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(d.charAt(n++));
var k="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(d.charAt(n++));x=x<<2|f>>4;f=(f&15)<<4|u>>2;var t=(u&3)<<6|k;m[r++]=x;64!==u&&(m[r++]=f);64!==k&&(m[r++]=t)}return m}},{"./support":30,"./utils":32}],2:[function(l,H,y){function h(u,m,x,f,k){this.compressedSize=u;this.uncompressedSize=m;this.crc32=x;this.compression=f;this.compressedContent=k}var q=l("./external"),d=l("./stream/DataWorker"),n=l("./stream/DataLengthProbe"),r=l("./stream/Crc32Probe");n=l("./stream/DataLengthProbe");
h.prototype={getContentWorker:function(){var u=(new d(q.Promise.resolve(this.compressedContent))).pipe(this.compression.uncompressWorker()).pipe(new n("data_length")),m=this;u.on("end",function(){if(this.streamInfo.data_length!==m.uncompressedSize)throw Error("Bug : uncompressed data size mismatch");});return u},getCompressedWorker:function(){return(new d(q.Promise.resolve(this.compressedContent))).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",
this.crc32).withStreamInfo("compression",this.compression)}};h.createWorkerFrom=function(u,m,x){return u.pipe(new r).pipe(new n("uncompressedSize")).pipe(m.compressWorker(x)).pipe(new n("compressedSize")).withStreamInfo("compression",m)};H.exports=h},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(l,H,y){var h=l("./stream/GenericWorker");y.STORE={magic:"\x00\x00",compressWorker:function(q){return new h("STORE compression")},uncompressWorker:function(){return new h("STORE decompression")}};
y.DEFLATE=l("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(l,H,y){var h=l("./utils"),q=function(){for(var d,n=[],r=0;256>r;r++){d=r;for(var u=0;8>u;u++)d=d&1?3988292384^d>>>1:d>>>1;n[r]=d}return n}();H.exports=function(d,n){if("undefined"===typeof d||!d.length)return 0;if("string"!==h.getTypeOf(d)){var r=0+d.length;n=(n|0)^-1;for(var u=0;u<r;u++)n=n>>>8^q[(n^d[u])&255];return n^-1}r=0+d.length;n=(n|0)^-1;for(u=0;u<r;u++)n=n>>>8^q[(n^d.charCodeAt(u))&255];return n^-1}},{"./utils":32}],
5:[function(l,H,y){y.base64=!1;y.binary=!1;y.dir=!1;y.createFolders=!0;y.date=null;y.compression=null;y.compressionOptions=null;y.comment=null;y.unixPermissions=null;y.dosPermissions=null},{}],6:[function(l,H,y){l="undefined"!==typeof Promise?Promise:l("lie");H.exports={Promise:l}},{lie:58}],7:[function(l,H,y){function h(u,m){n.call(this,"FlateWorker/"+u);this._pako=null;this._pakoAction=u;this._pakoOptions=m;this.meta={}}H="undefined"!==typeof Uint8Array&&"undefined"!==typeof Uint16Array&&"undefined"!==
typeof Uint32Array;var q=l("pako"),d=l("./utils"),n=l("./stream/GenericWorker"),r=H?"uint8array":"array";y.magic="\b\x00";d.inherits(h,n);h.prototype.processChunk=function(u){this.meta=u.meta;null===this._pako&&this._createPako();this._pako.push(d.transformTo(r,u.data),!1)};h.prototype.flush=function(){n.prototype.flush.call(this);null===this._pako&&this._createPako();this._pako.push([],!0)};h.prototype.cleanUp=function(){n.prototype.cleanUp.call(this);this._pako=null};h.prototype._createPako=function(){this._pako=
new q[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var u=this;this._pako.onData=function(m){u.push({data:m,meta:u.meta})}};y.compressWorker=function(u){return new h("Deflate",u)};y.uncompressWorker=function(){return new h("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:59}],8:[function(l,H,y){function h(k,t,C,w){d.call(this,"ZipFileWorker");this.bytesWritten=0;this.zipComment=t;this.zipPlatform=C;this.encodeFileName=w;this.streamFiles=k;this.accumulate=!1;this.contentBuffer=
[];this.dirRecords=[];this.entriesCount=this.currentSourceOffset=0;this.currentFile=null;this._sources=[]}var q=l("../utils"),d=l("../stream/GenericWorker"),n=l("../utf8"),r=l("../crc32"),u=l("../signature"),m=function(k,t){var C="",w;for(w=0;w<t;w++)C+=String.fromCharCode(k&255),k>>>=8;return C},x=function(k,t,C,w,p,v){var g=k.file,F=k.compression,G=v!==n.utf8encode,I=q.transformTo("string",v(g.name)),K=q.transformTo("string",n.utf8encode(g.name)),c=g.comment;v=q.transformTo("string",v(c));var N=
q.transformTo("string",n.utf8encode(c)),P=K.length!==g.name.length,a=N.length!==c.length;c="";var B=g.dir;var e=g.date,A=0,z=0,D=0;if(!t||C)A=k.crc32,z=k.compressedSize,D=k.uncompressedSize;k=0;t&&(k|=8);G||!P&&!a||(k|=2048);t=0;B&&(t|=16);"UNIX"===p?(p=798,(G=g=g.unixPermissions)||(G=B?16893:33204),t|=(G&65535)<<16):(p=20,t|=(g.dosPermissions||0)&63);g=e.getUTCHours();g=g<<6|e.getUTCMinutes();g=g<<5|e.getUTCSeconds()/2;B=e.getUTCFullYear()-1980;B=B<<4|e.getUTCMonth()+1;B=B<<5|e.getUTCDate();P&&(K=
m(1,1)+m(r(I),4)+K,c+="up"+m(K.length,2)+K);a&&(K=m(1,1)+m(r(v),4)+N,c+="uc"+m(K.length,2)+K);K="\n\x00"+m(k,2);K+=F.magic;K+=m(g,2);K+=m(B,2);K+=m(A,4);K+=m(z,4);K+=m(D,4);K+=m(I.length,2);K+=m(c.length,2);F=u.LOCAL_FILE_HEADER+K+I+c;w=u.CENTRAL_FILE_HEADER+m(p,2)+K+m(v.length,2)+"\x00\x00\x00\x00"+m(t,4)+m(w,4)+I+c+v;return{fileRecord:F,dirRecord:w}},f=function(k){return u.DATA_DESCRIPTOR+m(k.crc32,4)+m(k.compressedSize,4)+m(k.uncompressedSize,4)};q.inherits(h,d);h.prototype.push=function(k){var t=
k.meta.percent||0,C=this.entriesCount,w=this._sources.length;this.accumulate?this.contentBuffer.push(k):(this.bytesWritten+=k.data.length,d.prototype.push.call(this,{data:k.data,meta:{currentFile:this.currentFile,percent:C?(t+100*(C-w-1))/C:100}}))};h.prototype.openedSource=function(k){this.currentSourceOffset=this.bytesWritten;this.currentFile=k.file.name;var t=this.streamFiles&&!k.file.dir;t?(k=x(k,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName),this.push({data:k.fileRecord,
meta:{percent:0}})):this.accumulate=!0};h.prototype.closedSource=function(k){this.accumulate=!1;var t=this.streamFiles&&!k.file.dir,C=x(k,t,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.dirRecords.push(C.dirRecord);if(t)this.push({data:f(k),meta:{percent:100}});else for(this.push({data:C.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null};h.prototype.flush=function(){for(var k=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],
meta:{percent:100}});t=this.dirRecords.length;var C=this.bytesWritten-k,w=q.transformTo("string",(0,this.encodeFileName)(this.zipComment));k=u.CENTRAL_DIRECTORY_END+"\x00\x00\x00\x00"+m(t,2)+m(t,2)+m(C,4)+m(k,4)+m(w.length,2)+w;this.push({data:k,meta:{percent:100}})};h.prototype.prepareNextSource=function(){this.previous=this._sources.shift();this.openedSource(this.previous.streamInfo);this.isPaused?this.previous.pause():this.previous.resume()};h.prototype.registerPrevious=function(k){this._sources.push(k);
var t=this;k.on("data",function(C){t.processChunk(C)});k.on("end",function(){t.closedSource(t.previous.streamInfo);t._sources.length?t.prepareNextSource():t.end()});k.on("error",function(C){t.error(C)});return this};h.prototype.resume=function(){if(!d.prototype.resume.call(this))return!1;if(!this.previous&&this._sources.length)return this.prepareNextSource(),!0;if(!this.previous&&!this._sources.length&&!this.generatedError)return this.end(),!0};h.prototype.error=function(k){var t=this._sources;if(!d.prototype.error.call(this,
k))return!1;for(var C=0;C<t.length;C++)try{t[C].error(k)}catch(w){}return!0};h.prototype.lock=function(){d.prototype.lock.call(this);for(var k=this._sources,t=0;t<k.length;t++)k[t].lock()};H.exports=h},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(l,H,y){var h=l("../compressions"),q=l("./ZipFileWorker");y.generateWorker=function(d,n,r){var u=new q(n.streamFiles,r,n.platform,n.encodeFileName),m=0;try{d.forEach(function(x,f){m++;var k=f.options.compression||
n.compression,t=h[k];if(!t)throw Error(k+" is not a valid compression method !");k=f.dir;var C=f.date;f._compressWorker(t,f.options.compressionOptions||n.compressionOptions||{}).withStreamInfo("file",{name:x,dir:k,date:C,comment:f.comment||"",unixPermissions:f.unixPermissions,dosPermissions:f.dosPermissions}).pipe(u)}),u.entriesCount=m}catch(x){u.error(x)}return u}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(l,H,y){function h(){if(!(this instanceof h))return new h;if(arguments.length)throw Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
this.files={};this.comment=null;this.root="";this.clone=function(){var q=new h,d;for(d in this)"function"!==typeof this[d]&&(q[d]=this[d]);return q}}h.prototype=l("./object");h.prototype.loadAsync=l("./load");h.support=l("./support");h.defaults=l("./defaults");h.version="3.1.5";h.loadAsync=function(q,d){return(new h).loadAsync(q,d)};h.external=l("./external");H.exports=h},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(l,H,y){function h(x){return new d.Promise(function(f,
k){var t=x.decompressed.getContentWorker().pipe(new u);t.on("error",function(C){k(C)}).on("end",function(){t.streamInfo.crc32!==x.decompressed.crc32?k(Error("Corrupted zip : CRC32 mismatch")):f()}).resume()})}var q=l("./utils"),d=l("./external"),n=l("./utf8");q=l("./utils");var r=l("./zipEntries"),u=l("./stream/Crc32Probe"),m=l("./nodejsUtils");H.exports=function(x,f){var k=this;f=q.extend(f||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:n.utf8decode});return m.isNode&&
m.isStream(x)?d.Promise.reject(Error("JSZip can't accept a stream when loading a zip file.")):q.prepareContent("the loaded zip file",x,!0,f.optimizedBinaryString,f.base64).then(function(t){var C=new r(f);C.load(t);return C}).then(function(t){var C=[d.Promise.resolve(t)];t=t.files;if(f.checkCRC32)for(var w=0;w<t.length;w++)C.push(h(t[w]));return d.Promise.all(C)}).then(function(t){t=t.shift();for(var C=t.files,w=0;w<C.length;w++){var p=C[w];k.file(p.fileNameStr,p.decompressed,{binary:!0,optimizedBinaryString:!0,
date:p.date,dir:p.dir,comment:p.fileCommentStr.length?p.fileCommentStr:null,unixPermissions:p.unixPermissions,dosPermissions:p.dosPermissions,createFolders:f.createFolders})}t.zipComment.length&&(k.comment=t.zipComment);return k})}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(l,H,y){function h(d,n){q.call(this,"Nodejs stream input adapter for "+d);this._upstreamEnded=!1;this._bindStream(n)}y=l("../utils");var q=l("../stream/GenericWorker");
y.inherits(h,q);h.prototype._bindStream=function(d){var n=this;this._stream=d;d.pause();d.on("data",function(r){n.push({data:r,meta:{percent:0}})}).on("error",function(r){n.isPaused?this.generatedError=r:n.error(r)}).on("end",function(){n.isPaused?n._upstreamEnded=!0:n.end()})};h.prototype.pause=function(){if(!q.prototype.pause.call(this))return!1;this._stream.pause();return!0};h.prototype.resume=function(){if(!q.prototype.resume.call(this))return!1;this._upstreamEnded?this.end():this._stream.resume();
return!0};H.exports=h},{"../stream/GenericWorker":28,"../utils":32}],13:[function(l,H,y){function h(d,n,r){q.call(this,n);this._helper=d;var u=this;d.on("data",function(m,x){u.push(m)||u._helper.pause();r&&r(x)}).on("error",function(m){u.emit("error",m)}).on("end",function(){u.push(null)})}var q=l("readable-stream").Readable;l("../utils").inherits(h,q);h.prototype._read=function(){this._helper.resume()};H.exports=h},{"../utils":32,"readable-stream":16}],14:[function(l,H,y){H.exports={isNode:"undefined"!==
typeof Buffer,newBufferFrom:function(h,q){return new Buffer(h,q)},allocBuffer:function(h){return Buffer.alloc?Buffer.alloc(h):new Buffer(h)},isBuffer:function(h){return Buffer.isBuffer(h)},isStream:function(h){return h&&"function"===typeof h.on&&"function"===typeof h.pause&&"function"===typeof h.resume}}},{}],15:[function(l,H,y){var h=l("./utf8"),q=l("./utils"),d=l("./stream/GenericWorker"),n=l("./stream/StreamHelper"),r=l("./defaults"),u=l("./compressedObject"),m=l("./zipObject"),x=l("./generate"),
f=l("./nodejsUtils"),k=l("./nodejs/NodejsStreamInputAdapter"),t=function(p,v,g){var F=q.getTypeOf(v),G=q.extend(g||{},r);G.date=G.date||new Date;null!==G.compression&&(G.compression=G.compression.toUpperCase());"string"===typeof G.unixPermissions&&(G.unixPermissions=parseInt(G.unixPermissions,8));G.unixPermissions&&G.unixPermissions&16384&&(G.dir=!0);G.dosPermissions&&G.dosPermissions&16&&(G.dir=!0);G.dir&&(p=C(p));var I;if(I=G.createFolders){var K=p;"/"===K.slice(-1)&&(K=K.substring(0,K.length-1));
I=K.lastIndexOf("/");I=K=0<I?K.substring(0,I):""}I&&w.call(this,K,!0);F="string"===F&&!1===G.binary&&!1===G.base64;g&&"undefined"!==typeof g.binary||(G.binary=!F);if(v instanceof u&&0===v.uncompressedSize||G.dir||!v||0===v.length)G.base64=!1,G.binary=!0,v="",G.compression="STORE";v=v instanceof u||v instanceof d?v:f.isNode&&f.isStream(v)?new k(p,v):q.prepareContent(p,v,G.binary,G.optimizedBinaryString,G.base64);G=new m(p,v,G);this.files[p]=G},C=function(p){"/"!==p.slice(-1)&&(p+="/");return p},w=
function(p,v){v="undefined"!==typeof v?v:r.createFolders;p=C(p);this.files[p]||t.call(this,p,null,{dir:!0,createFolders:v});return this.files[p]};H.exports={load:function(){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},forEach:function(p){var v,g;for(v in this.files)if(this.files.hasOwnProperty(v)){var F=this.files[v];(g=v.slice(this.root.length,v.length))&&v.slice(0,this.root.length)===this.root&&p(g,F)}},filter:function(p){var v=[];this.forEach(function(g,
F){p(g,F)&&v.push(F)});return v},file:function(p,v,g){if(1===arguments.length){if("[object RegExp]"===Object.prototype.toString.call(p)){var F=p;return this.filter(function(I,K){return!K.dir&&F.test(I)})}var G=this.files[this.root+p];return G&&!G.dir?G:null}p=this.root+p;t.call(this,p,v,g);return this},folder:function(p){if(!p)return this;if("[object RegExp]"===Object.prototype.toString.call(p))return this.filter(function(F,G){return G.dir&&p.test(F)});var v=w.call(this,this.root+p),g=this.clone();
g.root=v.name;return g},remove:function(p){p=this.root+p;var v=this.files[p];v||("/"!==p.slice(-1)&&(p+="/"),v=this.files[p]);if(v&&!v.dir)delete this.files[p];else{v=this.filter(function(F,G){return G.name.slice(0,p.length)===p});for(var g=0;g<v.length;g++)delete this.files[v[g].name]}return this},generate:function(p){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},generateInternalStream:function(p){var v={};try{v=q.extend(p||{},{streamFiles:!1,compression:"STORE",
compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:h.utf8encode});v.type=v.type.toLowerCase();v.compression=v.compression.toUpperCase();"binarystring"===v.type&&(v.type="string");if(!v.type)throw Error("No output type specified.");q.checkSupport(v.type);if("darwin"===v.platform||"freebsd"===v.platform||"linux"===v.platform||"sunos"===v.platform)v.platform="UNIX";"win32"===v.platform&&(v.platform="DOS");var g=x.generateWorker(this,v,v.comment||this.comment||
"")}catch(F){g=new d("error"),g.error(F)}return new n(g,v.type||"string",v.mimeType)},generateAsync:function(p,v){return this.generateInternalStream(p).accumulate(v)},generateNodeStream:function(p,v){p=p||{};p.type||(p.type="nodebuffer");return this.generateInternalStream(p).toNodejsStream(v)}}},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],
16:[function(l,H,y){H.exports=l("stream")},{stream:void 0}],17:[function(l,H,y){function h(d){q.call(this,d);for(var n=0;n<this.data.length;n++)d[n]&=255}var q=l("./DataReader");l("../utils").inherits(h,q);h.prototype.byteAt=function(d){return this.data[this.zero+d]};h.prototype.lastIndexOfSignature=function(d){var n=d.charCodeAt(0),r=d.charCodeAt(1),u=d.charCodeAt(2);d=d.charCodeAt(3);for(var m=this.length-4;0<=m;--m)if(this.data[m]===n&&this.data[m+1]===r&&this.data[m+2]===u&&this.data[m+3]===d)return m-
this.zero;return-1};h.prototype.readAndCheckSignature=function(d){var n=d.charCodeAt(0),r=d.charCodeAt(1),u=d.charCodeAt(2);d=d.charCodeAt(3);var m=this.readData(4);return n===m[0]&&r===m[1]&&u===m[2]&&d===m[3]};h.prototype.readData=function(d){this.checkOffset(d);if(0===d)return[];var n=this.data.slice(this.zero+this.index,this.zero+this.index+d);this.index+=d;return n};H.exports=h},{"../utils":32,"./DataReader":18}],18:[function(l,H,y){function h(d){this.data=d;this.length=d.length;this.zero=this.index=
0}var q=l("../utils");h.prototype={checkOffset:function(d){this.checkIndex(this.index+d)},checkIndex:function(d){if(this.length<this.zero+d||0>d)throw Error("End of data reached (data length = "+this.length+", asked index = "+d+"). Corrupted zip ?");},setIndex:function(d){this.checkIndex(d);this.index=d},skip:function(d){this.setIndex(this.index+d)},byteAt:function(d){},readInt:function(d){var n=0,r;this.checkOffset(d);for(r=this.index+d-1;r>=this.index;r--)n=(n<<8)+this.byteAt(r);this.index+=d;return n},
readString:function(d){return q.transformTo("string",this.readData(d))},readData:function(d){},lastIndexOfSignature:function(d){},readAndCheckSignature:function(d){},readDate:function(){var d=this.readInt(4);return new Date(Date.UTC((d>>25&127)+1980,(d>>21&15)-1,d>>16&31,d>>11&31,d>>5&63,(d&31)<<1))}};H.exports=h},{"../utils":32}],19:[function(l,H,y){function h(d){q.call(this,d)}var q=l("./Uint8ArrayReader");l("../utils").inherits(h,q);h.prototype.readData=function(d){this.checkOffset(d);var n=this.data.slice(this.zero+
this.index,this.zero+this.index+d);this.index+=d;return n};H.exports=h},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(l,H,y){function h(d){q.call(this,d)}var q=l("./DataReader");l("../utils").inherits(h,q);h.prototype.byteAt=function(d){return this.data.charCodeAt(this.zero+d)};h.prototype.lastIndexOfSignature=function(d){return this.data.lastIndexOf(d)-this.zero};h.prototype.readAndCheckSignature=function(d){var n=this.readData(4);return d===n};h.prototype.readData=function(d){this.checkOffset(d);
var n=this.data.slice(this.zero+this.index,this.zero+this.index+d);this.index+=d;return n};H.exports=h},{"../utils":32,"./DataReader":18}],21:[function(l,H,y){function h(d){q.call(this,d)}var q=l("./ArrayReader");l("../utils").inherits(h,q);h.prototype.readData=function(d){this.checkOffset(d);if(0===d)return new Uint8Array(0);var n=this.data.subarray(this.zero+this.index,this.zero+this.index+d);this.index+=d;return n};H.exports=h},{"../utils":32,"./ArrayReader":17}],22:[function(l,H,y){var h=l("../utils"),
q=l("../support"),d=l("./ArrayReader"),n=l("./StringReader"),r=l("./NodeBufferReader"),u=l("./Uint8ArrayReader");H.exports=function(m){var x=h.getTypeOf(m);h.checkSupport(x);return"string"!==x||q.uint8array?"nodebuffer"===x?new r(m):q.uint8array?new u(h.transformTo("uint8array",m)):new d(h.transformTo("array",m)):new n(m)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(l,H,y){y.LOCAL_FILE_HEADER="PK\u0003\u0004";
y.CENTRAL_FILE_HEADER="PK\u0001\u0002";y.CENTRAL_DIRECTORY_END="PK\u0005\u0006";y.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK\u0006\u0007";y.ZIP64_CENTRAL_DIRECTORY_END="PK\u0006\u0006";y.DATA_DESCRIPTOR="PK\u0007\b"},{}],24:[function(l,H,y){function h(n){q.call(this,"ConvertWorker to "+n);this.destType=n}var q=l("./GenericWorker"),d=l("../utils");d.inherits(h,q);h.prototype.processChunk=function(n){this.push({data:d.transformTo(this.destType,n.data),meta:n.meta})};H.exports=h},{"../utils":32,"./GenericWorker":28}],
25:[function(l,H,y){function h(){q.call(this,"Crc32Probe");this.withStreamInfo("crc32",0)}var q=l("./GenericWorker"),d=l("../crc32");l("../utils").inherits(h,q);h.prototype.processChunk=function(n){this.streamInfo.crc32=d(n.data,this.streamInfo.crc32||0);this.push(n)};H.exports=h},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(l,H,y){function h(d){q.call(this,"DataLengthProbe for "+d);this.propName=d;this.withStreamInfo(d,0)}y=l("../utils");var q=l("./GenericWorker");y.inherits(h,
q);h.prototype.processChunk=function(d){d&&(this.streamInfo[this.propName]=(this.streamInfo[this.propName]||0)+d.data.length);q.prototype.processChunk.call(this,d)};H.exports=h},{"../utils":32,"./GenericWorker":28}],27:[function(l,H,y){function h(n){d.call(this,"DataWorker");var r=this;this.dataIsReady=!1;this.max=this.index=0;this.data=null;this.type="";this._tickScheduled=!1;n.then(function(u){r.dataIsReady=!0;r.data=u;r.max=u&&u.length||0;r.type=q.getTypeOf(u);r.isPaused||r._tickAndRepeat()},function(u){r.error(u)})}
var q=l("../utils"),d=l("./GenericWorker");q.inherits(h,d);h.prototype.cleanUp=function(){d.prototype.cleanUp.call(this);this.data=null};h.prototype.resume=function(){if(!d.prototype.resume.call(this))return!1;!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,q.delay(this._tickAndRepeat,[],this));return!0};h.prototype._tickAndRepeat=function(){this._tickScheduled=!1;this.isPaused||this.isFinished||(this._tick(),this.isFinished||(q.delay(this._tickAndRepeat,[],this),this._tickScheduled=
!0))};h.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var n=null,r=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case "string":n=this.data.substring(this.index,r);break;case "uint8array":n=this.data.subarray(this.index,r);break;case "array":case "nodebuffer":n=this.data.slice(this.index,r)}this.index=r;return this.push({data:n,meta:{percent:this.max?this.index/this.max*100:0}})};H.exports=h},{"../utils":32,"./GenericWorker":28}],
28:[function(l,H,y){function h(q){this.name=q||"default";this.streamInfo={};this.generatedError=null;this.extraStreamInfo={};this.isPaused=!0;this.isLocked=this.isFinished=!1;this._listeners={data:[],end:[],error:[]};this.previous=null}h.prototype={push:function(q){this.emit("data",q)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(q){this.emit("error",q)}return!0},error:function(q){if(this.isFinished)return!1;this.isPaused?this.generatedError=
q:(this.isFinished=!0,this.emit("error",q),this.previous&&this.previous.error(q),this.cleanUp());return!0},on:function(q,d){this._listeners[q].push(d);return this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null;this._listeners=[]},emit:function(q,d){if(this._listeners[q])for(var n=0;n<this._listeners[q].length;n++)this._listeners[q][n].call(this,d)},pipe:function(q){return q.registerPrevious(this)},registerPrevious:function(q){if(this.isLocked)throw Error("The stream '"+
this+"' has already been used.");this.streamInfo=q.streamInfo;this.mergeStreamInfo();this.previous=q;var d=this;q.on("data",function(n){d.processChunk(n)});q.on("end",function(){d.end()});q.on("error",function(n){d.error(n)});return this},pause:function(){if(this.isPaused||this.isFinished)return!1;this.isPaused=!0;this.previous&&this.previous.pause();return!0},resume:function(){if(!this.isPaused||this.isFinished)return!1;var q=this.isPaused=!1;this.generatedError&&(this.error(this.generatedError),
q=!0);this.previous&&this.previous.resume();return!q},flush:function(){},processChunk:function(q){this.push(q)},withStreamInfo:function(q,d){this.extraStreamInfo[q]=d;this.mergeStreamInfo();return this},mergeStreamInfo:function(){for(var q in this.extraStreamInfo)this.extraStreamInfo.hasOwnProperty(q)&&(this.streamInfo[q]=this.extraStreamInfo[q])},lock:function(){if(this.isLocked)throw Error("The stream '"+this+"' has already been used.");this.isLocked=!0;this.previous&&this.previous.lock()},toString:function(){var q=
"Worker "+this.name;return this.previous?this.previous+" -> "+q:q}};H.exports=h},{}],29:[function(l,H,y){function h(k,t){var C,w=0,p=0;for(C=0;C<t.length;C++)p+=t[C].length;switch(k){case "string":return t.join("");case "array":return Array.prototype.concat.apply([],t);case "uint8array":k=new Uint8Array(p);for(C=0;C<t.length;C++)k.set(t[C],w),w+=t[C].length;return k;case "nodebuffer":return Buffer.concat(t);default:throw Error("concat : unsupported type '"+k+"'");}}function q(k,t){return new x.Promise(function(C,
w){var p=[],v=k._internalType,g=k._outputType,F=k._mimeType;k.on("data",function(G,I){p.push(G);t&&t(I)}).on("error",function(G){p=[];w(G)}).on("end",function(){try{a:{var G=h(v,p);switch(g){case "blob":var I=n.newBlob(n.transformTo("arraybuffer",G),F);break a;case "base64":I=m.encode(G);break a;default:I=n.transformTo(g,G)}}C(I)}catch(K){w(K)}p=[]}).resume()})}function d(k,t,C){var w=t;switch(t){case "blob":case "arraybuffer":w="uint8array";break;case "base64":w="string"}try{this._internalType=w,
this._outputType=t,this._mimeType=C,n.checkSupport(w),this._worker=k.pipe(new r(w)),k.lock()}catch(p){this._worker=new u("error"),this._worker.error(p)}}var n=l("../utils"),r=l("./ConvertWorker"),u=l("./GenericWorker"),m=l("../base64");y=l("../support");var x=l("../external"),f=null;if(y.nodestream)try{f=l("../nodejs/NodejsStreamOutputAdapter")}catch(k){}d.prototype={accumulate:function(k){return q(this,k)},on:function(k,t){var C=this;if("data"===k)this._worker.on(k,function(w){t.call(C,w.data,w.meta)});
else this._worker.on(k,function(){n.delay(t,arguments,C)});return this},resume:function(){n.delay(this._worker.resume,[],this._worker);return this},pause:function(){this._worker.pause();return this},toNodejsStream:function(k){n.checkSupport("nodestream");if("nodebuffer"!==this._outputType)throw Error(this._outputType+" is not supported by this method");return new f(this,{objectMode:"nodebuffer"!==this._outputType},k)}};H.exports=d},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,
"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(l,H,y){y.base64=!0;y.array=!0;y.string=!0;y.arraybuffer="undefined"!==typeof ArrayBuffer&&"undefined"!==typeof Uint8Array;y.nodebuffer="undefined"!==typeof Buffer;y.uint8array="undefined"!==typeof Uint8Array;if("undefined"===typeof ArrayBuffer)y.blob=!1;else{H=new ArrayBuffer(0);try{y.blob=0===(new Blob([H],{type:"application/zip"})).size}catch(q){try{var h=new (self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||
self.MSBlobBuilder);h.append(H);y.blob=0===h.getBlob("application/zip").size}catch(d){y.blob=!1}}}try{y.nodestream=!!l("readable-stream").Readable}catch(q){y.nodestream=!1}},{"readable-stream":16}],31:[function(l,H,y){function h(){u.call(this,"utf-8 decode");this.leftOver=null}function q(){u.call(this,"utf-8 encode")}var d=l("./utils"),n=l("./support"),r=l("./nodejsUtils"),u=l("./stream/GenericWorker"),m=Array(256);for(l=0;256>l;l++)m[l]=252<=l?6:248<=l?5:240<=l?4:224<=l?3:192<=l?2:1;m[254]=m[254]=
1;y.utf8encode=function(x){if(n.nodebuffer)return r.newBufferFrom(x,"utf-8");var f,k,t=x.length,C=0;for(f=0;f<t;f++){var w=x.charCodeAt(f);if(55296===(w&64512)&&f+1<t){var p=x.charCodeAt(f+1);56320===(p&64512)&&(w=65536+(w-55296<<10)+(p-56320),f++)}C+=128>w?1:2048>w?2:65536>w?3:4}var v=n.uint8array?new Uint8Array(C):Array(C);for(f=k=0;k<C;f++)w=x.charCodeAt(f),55296===(w&64512)&&f+1<t&&(p=x.charCodeAt(f+1),56320===(p&64512)&&(w=65536+(w-55296<<10)+(p-56320),f++)),128>w?v[k++]=w:(2048>w?v[k++]=192|
w>>>6:(65536>w?v[k++]=224|w>>>12:(v[k++]=240|w>>>18,v[k++]=128|w>>>12&63),v[k++]=128|w>>>6&63),v[k++]=128|w&63);return v};y.utf8decode=function(x){if(n.nodebuffer)return d.transformTo("nodebuffer",x).toString("utf-8");x=d.transformTo(n.uint8array?"uint8array":"array",x);var f,k,t=x.length,C=Array(2*t);for(f=k=0;f<t;){var w=x[f++];if(128>w)C[k++]=w;else{var p=m[w];if(4<p)C[k++]=65533,f+=p-1;else{for(w&=2===p?31:3===p?15:7;1<p&&f<t;)w=w<<6|x[f++]&63,p--;1<p?C[k++]=65533:65536>w?C[k++]=w:(w-=65536,C[k++]=
55296|w>>10&1023,C[k++]=56320|w&1023)}}}C.length!==k&&(C.subarray?C=C.subarray(0,k):C.length=k);return d.applyFromCharCode(C)};d.inherits(h,u);h.prototype.processChunk=function(x){var f=d.transformTo(n.uint8array?"uint8array":"array",x.data);if(this.leftOver&&this.leftOver.length){if(n.uint8array){var k=f;f=new Uint8Array(k.length+this.leftOver.length);f.set(this.leftOver,0);f.set(k,this.leftOver.length)}else f=this.leftOver.concat(f);this.leftOver=null}var t;k=f.length;k>f.length&&(k=f.length);for(t=
k-1;0<=t&&128===(f[t]&192);)t--;k=0>t?k:0===t?k:t+m[f[t]]>k?t:k;t=f;k!==f.length&&(n.uint8array?(t=f.subarray(0,k),this.leftOver=f.subarray(k,f.length)):(t=f.slice(0,k),this.leftOver=f.slice(k,f.length)));this.push({data:y.utf8decode(t),meta:x.meta})};h.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:y.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)};y.Utf8DecodeWorker=h;d.inherits(q,u);q.prototype.processChunk=function(x){this.push({data:y.utf8encode(x.data),
meta:x.meta})};y.Utf8EncodeWorker=q},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(l,H,y){function h(p){return p}function q(p,v){for(var g=0;g<p.length;++g)v[g]=p.charCodeAt(g)&255;return v}function d(p){var v=65536,g=y.getTypeOf(p),F=!0;"uint8array"===g?F=C.applyCanBeUsed.uint8array:"nodebuffer"===g&&(F=C.applyCanBeUsed.nodebuffer);if(F)for(;1<v;)try{return C.stringifyByChunk(p,g,v)}catch(G){v=Math.floor(v/2)}return C.stringifyByChar(p)}function n(p,v){for(var g=
0;g<p.length;g++)v[g]=p[g];return v}var r=l("./support"),u=l("./base64"),m=l("./nodejsUtils"),x=l("core-js/library/fn/set-immediate"),f=l("./external");y.newBlob=function(p,v){y.checkSupport("blob");try{return new Blob([p],{type:v})}catch(F){try{var g=new (self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);g.append(p);return g.getBlob(v)}catch(G){throw Error("Bug : can't construct the Blob.");}}};try{var k=r.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(p){k=
!1}l=k;try{var t=r.nodebuffer&&1===String.fromCharCode.apply(null,m.allocBuffer(1)).length}catch(p){t=!1}var C={stringifyByChunk:function(p,v,g){var F=[],G=0,I=p.length;if(I<=g)return String.fromCharCode.apply(null,p);for(;G<I;)"array"===v||"nodebuffer"===v?F.push(String.fromCharCode.apply(null,p.slice(G,Math.min(G+g,I)))):F.push(String.fromCharCode.apply(null,p.subarray(G,Math.min(G+g,I)))),G+=g;return F.join("")},stringifyByChar:function(p){for(var v="",g=0;g<p.length;g++)v+=String.fromCharCode(p[g]);
return v},applyCanBeUsed:{uint8array:l,nodebuffer:t}};y.applyFromCharCode=d;var w={};w.string={string:h,array:function(p){return q(p,Array(p.length))},arraybuffer:function(p){return w.string.uint8array(p).buffer},uint8array:function(p){return q(p,new Uint8Array(p.length))},nodebuffer:function(p){return q(p,m.allocBuffer(p.length))}};w.array={string:d,array:h,arraybuffer:function(p){return(new Uint8Array(p)).buffer},uint8array:function(p){return new Uint8Array(p)},nodebuffer:function(p){return m.newBufferFrom(p)}};
w.arraybuffer={string:function(p){return d(new Uint8Array(p))},array:function(p){return n(new Uint8Array(p),Array(p.byteLength))},arraybuffer:h,uint8array:function(p){return new Uint8Array(p)},nodebuffer:function(p){return m.newBufferFrom(new Uint8Array(p))}};w.uint8array={string:d,array:function(p){return n(p,Array(p.length))},arraybuffer:function(p){return p.buffer},uint8array:h,nodebuffer:function(p){return m.newBufferFrom(p)}};w.nodebuffer={string:d,array:function(p){return n(p,Array(p.length))},
arraybuffer:function(p){return w.nodebuffer.uint8array(p).buffer},uint8array:function(p){return n(p,new Uint8Array(p.length))},nodebuffer:h};y.transformTo=function(p,v){v||(v="");if(!p)return v;y.checkSupport(p);var g=y.getTypeOf(v);return w[g][p](v)};y.getTypeOf=function(p){if("string"===typeof p)return"string";if("[object Array]"===Object.prototype.toString.call(p))return"array";if(r.nodebuffer&&m.isBuffer(p))return"nodebuffer";if(r.uint8array&&p instanceof Uint8Array)return"uint8array";if(r.arraybuffer&&
p instanceof ArrayBuffer)return"arraybuffer"};y.checkSupport=function(p){if(!r[p.toLowerCase()])throw Error(p+" is not supported by this platform");};y.MAX_VALUE_16BITS=65535;y.MAX_VALUE_32BITS=-1;y.pretty=function(p){var v="",g;for(g=0;g<(p||"").length;g++){var F=p.charCodeAt(g);v+="\\x"+(16>F?"0":"")+F.toString(16).toUpperCase()}return v};y.delay=function(p,v,g){x(function(){p.apply(g||null,v||[])})};y.inherits=function(p,v){var g=function(){};g.prototype=v.prototype;p.prototype=new g};y.extend=
function(){var p={},v,g;for(v=0;v<arguments.length;v++)for(g in arguments[v])arguments[v].hasOwnProperty(g)&&"undefined"===typeof p[g]&&(p[g]=arguments[v][g]);return p};y.prepareContent=function(p,v,g,F,G){return f.Promise.resolve(v).then(function(I){return r.blob&&(I instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(I)))&&"undefined"!==typeof FileReader?new f.Promise(function(K,c){var N=new FileReader;N.onload=function(P){K(P.target.result)};N.onerror=
function(P){c(P.target.error)};N.readAsArrayBuffer(I)}):I}).then(function(I){var K=y.getTypeOf(I);if(!K)return f.Promise.reject(Error("Can't read the data of '"+p+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"));"arraybuffer"===K?I=y.transformTo("uint8array",I):"string"===K&&(G?I=u.decode(I):g&&!0!==F&&(K=r.uint8array?new Uint8Array(I.length):Array(I.length),I=q(I,K)));return I})}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,"core-js/library/fn/set-immediate":36}],
33:[function(l,H,y){function h(m){this.files=[];this.loadOptions=m}var q=l("./reader/readerFor"),d=l("./utils"),n=l("./signature"),r=l("./zipEntry");l("./utf8");var u=l("./support");h.prototype={checkSignature:function(m){if(!this.reader.readAndCheckSignature(m)){this.reader.index-=4;var x=this.reader.readString(4);throw Error("Corrupted zip or bug: unexpected signature ("+d.pretty(x)+", expected "+d.pretty(m)+")");}},isSignature:function(m,x){var f=this.reader.index;this.reader.setIndex(m);m=this.reader.readString(4)===
x;this.reader.setIndex(f);return m},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2);this.diskWithCentralDirStart=this.reader.readInt(2);this.centralDirRecordsOnThisDisk=this.reader.readInt(2);this.centralDirRecords=this.reader.readInt(2);this.centralDirSize=this.reader.readInt(4);this.centralDirOffset=this.reader.readInt(4);this.zipCommentLength=this.reader.readInt(2);var m=this.reader.readData(this.zipCommentLength);m=d.transformTo(u.uint8array?"uint8array":"array",m);this.zipComment=
this.loadOptions.decodeFileName(m)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8);this.reader.skip(4);this.diskNumber=this.reader.readInt(4);this.diskWithCentralDirStart=this.reader.readInt(4);this.centralDirRecordsOnThisDisk=this.reader.readInt(8);this.centralDirRecords=this.reader.readInt(8);this.centralDirSize=this.reader.readInt(8);this.centralDirOffset=this.reader.readInt(8);this.zip64ExtensibleData={};for(var m=this.zip64EndOfCentralSize-44,x,f,k;0<
m;)x=this.reader.readInt(2),f=this.reader.readInt(4),k=this.reader.readData(f),this.zip64ExtensibleData[x]={id:x,length:f,value:k}},readBlockZip64EndOfCentralLocator:function(){this.diskWithZip64CentralDirStart=this.reader.readInt(4);this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8);this.disksCount=this.reader.readInt(4);if(1<this.disksCount)throw Error("Multi-volumes zip are not supported");},readLocalFiles:function(){var m;for(m=0;m<this.files.length;m++){var x=this.files[m];this.reader.setIndex(x.localHeaderOffset);
this.checkSignature(n.LOCAL_FILE_HEADER);x.readLocalPart(this.reader);x.handleUTF8();x.processAttributes()}},readCentralDir:function(){for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(n.CENTRAL_FILE_HEADER);){var m=new r({zip64:this.zip64},this.loadOptions);m.readCentralPart(this.reader);this.files.push(m)}if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw Error("Corrupted zip or bug: expected "+this.centralDirRecords+
" records in central dir, got "+this.files.length);},readEndOfCentral:function(){var m=this.reader.lastIndexOfSignature(n.CENTRAL_DIRECTORY_END);if(0>m){if(this.isSignature(0,n.LOCAL_FILE_HEADER))throw Error("Corrupted zip: can't find end of central directory");throw Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");}this.reader.setIndex(m);var x=m;this.checkSignature(n.CENTRAL_DIRECTORY_END);this.readBlockEndOfCentral();
if(this.diskNumber===d.MAX_VALUE_16BITS||this.diskWithCentralDirStart===d.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===d.MAX_VALUE_16BITS||this.centralDirRecords===d.MAX_VALUE_16BITS||this.centralDirSize===d.MAX_VALUE_32BITS||this.centralDirOffset===d.MAX_VALUE_32BITS){this.zip64=!0;m=this.reader.lastIndexOfSignature(n.ZIP64_CENTRAL_DIRECTORY_LOCATOR);if(0>m)throw Error("Corrupted zip: can't find the ZIP64 end of central directory locator");this.reader.setIndex(m);this.checkSignature(n.ZIP64_CENTRAL_DIRECTORY_LOCATOR);
this.readBlockZip64EndOfCentralLocator();if(!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,n.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(n.ZIP64_CENTRAL_DIRECTORY_END),0>this.relativeOffsetEndOfZip64CentralDir))throw Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);this.checkSignature(n.ZIP64_CENTRAL_DIRECTORY_END);this.readBlockZip64EndOfCentral()}m=
this.centralDirOffset+this.centralDirSize;this.zip64&&(m=m+20+(12+this.zip64EndOfCentralSize));m=x-m;if(0<m)this.isSignature(x,n.CENTRAL_FILE_HEADER)||(this.reader.zero=m);else if(0>m)throw Error("Corrupted zip: missing "+Math.abs(m)+" bytes.");},prepareReader:function(m){this.reader=q(m)},load:function(m){this.prepareReader(m);this.readEndOfCentral();this.readCentralDir();this.readLocalFiles()}};H.exports=h},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utf8":31,"./utils":32,"./zipEntry":34}],
34:[function(l,H,y){function h(f,k){this.options=f;this.loadOptions=k}var q=l("./reader/readerFor"),d=l("./utils"),n=l("./compressedObject"),r=l("./crc32"),u=l("./utf8"),m=l("./compressions"),x=l("./support");h.prototype={isEncrypted:function(){return 1===(this.bitFlag&1)},useUTF8:function(){return 2048===(this.bitFlag&2048)},readLocalPart:function(f){f.skip(22);this.fileNameLength=f.readInt(2);var k=f.readInt(2);this.fileName=f.readData(this.fileNameLength);f.skip(k);if(-1===this.compressedSize||
-1===this.uncompressedSize)throw Error("Bug or corrupted zip : didn't get enough informations from the central directory (compressedSize === -1 || uncompressedSize === -1)");a:{k=this.compressionMethod;for(t in m)if(m.hasOwnProperty(t)&&m[t].magic===k){var t=m[t];break a}t=null}if(null===t)throw Error("Corrupted zip : compression "+d.pretty(this.compressionMethod)+" unknown (inner file : "+d.transformTo("string",this.fileName)+")");this.decompressed=new n(this.compressedSize,this.uncompressedSize,
this.crc32,t,f.readData(this.compressedSize))},readCentralPart:function(f){this.versionMadeBy=f.readInt(2);f.skip(2);this.bitFlag=f.readInt(2);this.compressionMethod=f.readString(2);this.date=f.readDate();this.crc32=f.readInt(4);this.compressedSize=f.readInt(4);this.uncompressedSize=f.readInt(4);var k=f.readInt(2);this.extraFieldsLength=f.readInt(2);this.fileCommentLength=f.readInt(2);this.diskNumberStart=f.readInt(2);this.internalFileAttributes=f.readInt(2);this.externalFileAttributes=f.readInt(4);
this.localHeaderOffset=f.readInt(4);if(this.isEncrypted())throw Error("Encrypted zip are not supported");f.skip(k);this.readExtraFields(f);this.parseZIP64ExtraField(f);this.fileComment=f.readData(this.fileCommentLength)},processAttributes:function(){this.dosPermissions=this.unixPermissions=null;var f=this.versionMadeBy>>8;this.dir=this.externalFileAttributes&16?!0:!1;0===f&&(this.dosPermissions=this.externalFileAttributes&63);3===f&&(this.unixPermissions=this.externalFileAttributes>>16&65535);this.dir||
"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(f){this.extraFields[1]&&(f=q(this.extraFields[1].value),this.uncompressedSize===d.MAX_VALUE_32BITS&&(this.uncompressedSize=f.readInt(8)),this.compressedSize===d.MAX_VALUE_32BITS&&(this.compressedSize=f.readInt(8)),this.localHeaderOffset===d.MAX_VALUE_32BITS&&(this.localHeaderOffset=f.readInt(8)),this.diskNumberStart===d.MAX_VALUE_32BITS&&(this.diskNumberStart=f.readInt(4)))},readExtraFields:function(f){var k=f.index+this.extraFieldsLength;
this.extraFields||(this.extraFields={});for(;f.index<k;){var t=f.readInt(2);var C=f.readInt(2);var w=f.readData(C);this.extraFields[t]={id:t,length:C,value:w}}},handleUTF8:function(){var f=x.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=u.utf8decode(this.fileName),this.fileCommentStr=u.utf8decode(this.fileComment);else{var k=this.findExtraFieldUnicodePath();null!==k?this.fileNameStr=k:(k=d.transformTo(f,this.fileName),this.fileNameStr=this.loadOptions.decodeFileName(k));k=this.findExtraFieldUnicodeComment();
null!==k?this.fileCommentStr=k:(f=d.transformTo(f,this.fileComment),this.fileCommentStr=this.loadOptions.decodeFileName(f))}},findExtraFieldUnicodePath:function(){var f=this.extraFields[28789];if(f){var k=q(f.value);return 1!==k.readInt(1)||r(this.fileName)!==k.readInt(4)?null:u.utf8decode(k.readData(f.length-5))}return null},findExtraFieldUnicodeComment:function(){var f=this.extraFields[25461];if(f){var k=q(f.value);return 1!==k.readInt(1)||r(this.fileComment)!==k.readInt(4)?null:u.utf8decode(k.readData(f.length-
5))}return null}};H.exports=h},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(l,H,y){var h=l("./stream/StreamHelper"),q=l("./stream/DataWorker"),d=l("./utf8"),n=l("./compressedObject"),r=l("./stream/GenericWorker");l=function(x,f,k){this.name=x;this.dir=k.dir;this.date=k.date;this.comment=k.comment;this.unixPermissions=k.unixPermissions;this.dosPermissions=k.dosPermissions;this._data=f;this._dataBinary=k.binary;
this.options={compression:k.compression,compressionOptions:k.compressionOptions}};l.prototype={internalStream:function(x){var f=null,k="string";try{if(!x)throw Error("No output type specified.");k=x.toLowerCase();x="string"===k||"text"===k;if("binarystring"===k||"text"===k)k="string";f=this._decompressWorker();var t=!this._dataBinary;t&&!x&&(f=f.pipe(new d.Utf8EncodeWorker));!t&&x&&(f=f.pipe(new d.Utf8DecodeWorker))}catch(C){f=new r("error"),f.error(C)}return new h(f,k,"")},async:function(x,f){return this.internalStream(x).accumulate(f)},
nodeStream:function(x,f){return this.internalStream(x||"nodebuffer").toNodejsStream(f)},_compressWorker:function(x,f){if(this._data instanceof n&&this._data.compression.magic===x.magic)return this._data.getCompressedWorker();var k=this._decompressWorker();this._dataBinary||(k=k.pipe(new d.Utf8EncodeWorker));return n.createWorkerFrom(k,x,f)},_decompressWorker:function(){return this._data instanceof n?this._data.getContentWorker():this._data instanceof r?this._data:new q(this._data)}};y=["asText","asBinary",
"asNodeBuffer","asUint8Array","asArrayBuffer"];for(var u=function(){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},m=0;m<y.length;m++)l.prototype[y[m]]=u;H.exports=l},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(l,H,y){l("../modules/web.immediate");H.exports=l("../modules/_core").setImmediate},{"../modules/_core":40,"../modules/web.immediate":56}],37:[function(l,H,y){H.exports=
function(h){if("function"!=typeof h)throw TypeError(h+" is not a function!");return h}},{}],38:[function(l,H,y){var h=l("./_is-object");H.exports=function(q){if(!h(q))throw TypeError(q+" is not an object!");return q}},{"./_is-object":51}],39:[function(l,H,y){var h={}.toString;H.exports=function(q){return h.call(q).slice(8,-1)}},{}],40:[function(l,H,y){l=H.exports={version:"2.3.0"};"number"==typeof __e&&(__e=l)},{}],41:[function(l,H,y){var h=l("./_a-function");H.exports=function(q,d,n){h(q);if(void 0===
d)return q;switch(n){case 1:return function(r){return q.call(d,r)};case 2:return function(r,u){return q.call(d,r,u)};case 3:return function(r,u,m){return q.call(d,r,u,m)}}return function(){return q.apply(d,arguments)}}},{"./_a-function":37}],42:[function(l,H,y){H.exports=!l("./_fails")(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a})},{"./_fails":45}],43:[function(l,H,y){y=l("./_is-object");var h=l("./_global").document,q=y(h)&&y(h.createElement);H.exports=function(d){return q?
h.createElement(d):{}}},{"./_global":46,"./_is-object":51}],44:[function(l,H,y){var h=l("./_global"),q=l("./_core"),d=l("./_ctx"),n=l("./_hide"),r=function(u,m,x){var f=u&r.F,k=u&r.G,t=u&r.S,C=u&r.P,w=u&r.B,p=u&r.W,v=k?q:q[m]||(q[m]={}),g=v.prototype;t=k?h:t?h[m]:(h[m]||{}).prototype;var F;k&&(x=m);for(F in x)if(m=!f&&t&&void 0!==t[F],!(m&&F in v)){var G=m?t[F]:x[F];v[F]=k&&"function"!=typeof t[F]?x[F]:w&&m?d(G,h):p&&t[F]==G?function(I){var K=function(c,N,P){if(this instanceof I){switch(arguments.length){case 0:return new I;
case 1:return new I(c);case 2:return new I(c,N)}return new I(c,N,P)}return I.apply(this,arguments)};K.prototype=I.prototype;return K}(G):C&&"function"==typeof G?d(Function.call,G):G;C&&((v.virtual||(v.virtual={}))[F]=G,u&r.R&&g&&!g[F]&&n(g,F,G))}};r.F=1;r.G=2;r.S=4;r.P=8;r.B=16;r.W=32;r.U=64;r.R=128;H.exports=r},{"./_core":40,"./_ctx":41,"./_global":46,"./_hide":47}],45:[function(l,H,y){H.exports=function(h){try{return!!h()}catch(q){return!0}}},{}],46:[function(l,H,y){l=H.exports="undefined"!=typeof window&&
Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=l)},{}],47:[function(l,H,y){var h=l("./_object-dp"),q=l("./_property-desc");H.exports=l("./_descriptors")?function(d,n,r){return h.f(d,n,q(1,r))}:function(d,n,r){d[n]=r;return d}},{"./_descriptors":42,"./_object-dp":52,"./_property-desc":53}],48:[function(l,H,y){H.exports=l("./_global").document&&document.documentElement},{"./_global":46}],49:[function(l,H,y){H.exports=!l("./_descriptors")&&
!l("./_fails")(function(){return 7!=Object.defineProperty(l("./_dom-create")("div"),"a",{get:function(){return 7}}).a})},{"./_descriptors":42,"./_dom-create":43,"./_fails":45}],50:[function(l,H,y){H.exports=function(h,q,d){var n=void 0===d;switch(q.length){case 0:return n?h():h.call(d);case 1:return n?h(q[0]):h.call(d,q[0]);case 2:return n?h(q[0],q[1]):h.call(d,q[0],q[1]);case 3:return n?h(q[0],q[1],q[2]):h.call(d,q[0],q[1],q[2]);case 4:return n?h(q[0],q[1],q[2],q[3]):h.call(d,q[0],q[1],q[2],q[3])}return h.apply(d,
q)}},{}],51:[function(l,H,y){H.exports=function(h){return"object"===typeof h?null!==h:"function"===typeof h}},{}],52:[function(l,H,y){var h=l("./_an-object"),q=l("./_ie8-dom-define"),d=l("./_to-primitive"),n=Object.defineProperty;y.f=l("./_descriptors")?Object.defineProperty:function(r,u,m){h(r);u=d(u,!0);h(m);if(q)try{return n(r,u,m)}catch(x){}if("get"in m||"set"in m)throw TypeError("Accessors not supported!");"value"in m&&(r[u]=m.value);return r}},{"./_an-object":38,"./_descriptors":42,"./_ie8-dom-define":49,
"./_to-primitive":55}],53:[function(l,H,y){H.exports=function(h,q){return{enumerable:!(h&1),configurable:!(h&2),writable:!(h&4),value:q}}},{}],54:[function(l,H,y){var h=l("./_ctx"),q=l("./_invoke"),d=l("./_html"),n=l("./_dom-create"),r=l("./_global"),u=r.process;y=r.setImmediate;var m=r.clearImmediate,x=r.MessageChannel,f=0,k={},t=function(){var p=+this;if(k.hasOwnProperty(p)){var v=k[p];delete k[p];v()}},C=function(p){t.call(p.data)};if(!y||!m)if(y=function(p){for(var v=[],g=1;arguments.length>g;)v.push(arguments[g++]);
k[++f]=function(){q("function"==typeof p?p:Function(p),v)};w(f);return f},m=function(p){delete k[p]},"process"==l("./_cof")(u))var w=function(p){u.nextTick(h(t,p,1))};else x?(l=new x,x=l.port2,l.port1.onmessage=C,w=h(x.postMessage,x,1)):r.addEventListener&&"function"==typeof postMessage&&!r.importScripts?(w=function(p){r.postMessage(p+"","*")},r.addEventListener("message",C,!1)):w="onreadystatechange"in n("script")?function(p){d.appendChild(n("script")).onreadystatechange=function(){d.removeChild(this);
t.call(p)}}:function(p){setTimeout(h(t,p,1),0)};H.exports={set:y,clear:m}},{"./_cof":39,"./_ctx":41,"./_dom-create":43,"./_global":46,"./_html":48,"./_invoke":50}],55:[function(l,H,y){var h=l("./_is-object");H.exports=function(q,d){if(!h(q))return q;var n,r;if(d&&"function"==typeof(n=q.toString)&&!h(r=n.call(q))||"function"==typeof(n=q.valueOf)&&!h(r=n.call(q))||!d&&"function"==typeof(n=q.toString)&&!h(r=n.call(q)))return r;throw TypeError("Can't convert object to primitive value");}},{"./_is-object":51}],
56:[function(l,H,y){H=l("./_export");l=l("./_task");H(H.G+H.B,{setImmediate:l.set,clearImmediate:l.clear})},{"./_export":44,"./_task":54}],57:[function(l,H,y){(function(h){function q(){x=!0;for(var k,t,C=f.length;C;){t=f;f=[];for(k=-1;++k<C;)t[k]();C=f.length}x=!1}var d=h.MutationObserver||h.WebKitMutationObserver;if(d){var n=0;d=new d(q);var r=h.document.createTextNode("");d.observe(r,{characterData:!0});var u=function(){r.data=n=++n%2}}else if(h.setImmediate||"undefined"===typeof h.MessageChannel)u=
"document"in h&&"onreadystatechange"in h.document.createElement("script")?function(){var k=h.document.createElement("script");k.onreadystatechange=function(){q();k.onreadystatechange=null;k.parentNode.removeChild(k);k=null};h.document.documentElement.appendChild(k)}:function(){setTimeout(q,0)};else{var m=new h.MessageChannel;m.port1.onmessage=q;u=function(){m.port2.postMessage(0)}}var x,f=[];H.exports=function(k){1!==f.push(k)||x||u()}}).call(this,"undefined"!==typeof global?global:"undefined"!==
typeof self?self:"undefined"!==typeof window?window:{})},{}],58:[function(l,H,y){function h(){}function q(w){if("function"!==typeof w)throw new TypeError("resolver must be a function");this.state=C;this.queue=[];this.outcome=void 0;w!==h&&u(this,w)}function d(w,p,v){this.promise=w;"function"===typeof p&&(this.onFulfilled=p,this.callFulfilled=this.otherCallFulfilled);"function"===typeof v&&(this.onRejected=v,this.callRejected=this.otherCallRejected)}function n(w,p,v){x(function(){try{var g=p(v)}catch(F){return f.reject(w,
F)}g===w?f.reject(w,new TypeError("Cannot resolve promise with itself")):f.resolve(w,g)})}function r(w){var p=w&&w.then;if(w&&("object"===typeof w||"function"===typeof w)&&"function"===typeof p)return function(){p.apply(w,arguments)}}function u(w,p){function v(I){F||(F=!0,f.reject(w,I))}function g(I){F||(F=!0,f.resolve(w,I))}var F=!1,G=m(function(){p(g,v)});"error"===G.status&&v(G.value)}function m(w,p){var v={};try{v.value=w(p),v.status="success"}catch(g){v.status="error",v.value=g}return v}var x=
l("immediate"),f={},k=["REJECTED"],t=["FULFILLED"],C=["PENDING"];H.exports=q;q.prototype["catch"]=function(w){return this.then(null,w)};q.prototype.then=function(w,p){if("function"!==typeof w&&this.state===t||"function"!==typeof p&&this.state===k)return this;var v=new this.constructor(h);this.state!==C?n(v,this.state===t?w:p,this.outcome):this.queue.push(new d(v,w,p));return v};d.prototype.callFulfilled=function(w){f.resolve(this.promise,w)};d.prototype.otherCallFulfilled=function(w){n(this.promise,
this.onFulfilled,w)};d.prototype.callRejected=function(w){f.reject(this.promise,w)};d.prototype.otherCallRejected=function(w){n(this.promise,this.onRejected,w)};f.resolve=function(w,p){var v=m(r,p);if("error"===v.status)return f.reject(w,v.value);if(v=v.value)u(w,v);else{w.state=t;w.outcome=p;v=-1;for(var g=w.queue.length;++v<g;)w.queue[v].callFulfilled(p)}return w};f.reject=function(w,p){w.state=k;w.outcome=p;for(var v=-1,g=w.queue.length;++v<g;)w.queue[v].callRejected(p);return w};q.resolve=function(w){return w instanceof
this?w:f.resolve(new this(h),w)};q.reject=function(w){var p=new this(h);return f.reject(p,w)};q.all=function(w){function p(N,P){v.resolve(N).then(function(a){G[P]=a;++I!==g||F||(F=!0,f.resolve(c,G))},function(a){F||(F=!0,f.reject(c,a))})}var v=this;if("[object Array]"!==Object.prototype.toString.call(w))return this.reject(new TypeError("must be an array"));var g=w.length,F=!1;if(!g)return this.resolve([]);for(var G=Array(g),I=0,K=-1,c=new this(h);++K<g;)p(w[K],K);return c};q.race=function(w){function p(K){v.resolve(K).then(function(c){F||
(F=!0,f.resolve(I,c))},function(c){F||(F=!0,f.reject(I,c))})}var v=this;if("[object Array]"!==Object.prototype.toString.call(w))return this.reject(new TypeError("must be an array"));var g=w.length,F=!1;if(!g)return this.resolve([]);for(var G=-1,I=new this(h);++G<g;)p(w[G]);return I}},{immediate:57}],59:[function(l,H,y){y=l("./lib/utils/common").assign;var h=l("./lib/deflate"),q=l("./lib/inflate");l=l("./lib/zlib/constants");var d={};y(d,h,q,l);H.exports=d},{"./lib/deflate":60,"./lib/inflate":61,"./lib/utils/common":62,
"./lib/zlib/constants":65}],60:[function(l,H,y){function h(f){if(!(this instanceof h))return new h(f);f=this.options=n.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:""},f||{});f.raw&&0<f.windowBits?f.windowBits=-f.windowBits:f.gzip&&0<f.windowBits&&16>f.windowBits&&(f.windowBits+=16);this.err=0;this.msg="";this.ended=!1;this.chunks=[];this.strm=new m;this.strm.avail_out=0;var k=d.deflateInit2(this.strm,f.level,f.method,f.windowBits,f.memLevel,f.strategy);if(0!==
k)throw Error(u[k]);f.header&&d.deflateSetHeader(this.strm,f.header);if(f.dictionary){f="string"===typeof f.dictionary?r.string2buf(f.dictionary):"[object ArrayBuffer]"===x.call(f.dictionary)?new Uint8Array(f.dictionary):f.dictionary;k=d.deflateSetDictionary(this.strm,f);if(0!==k)throw Error(u[k]);this._dict_set=!0}}function q(f,k){k=new h(k);k.push(f,!0);if(k.err)throw k.msg||u[k.err];return k.result}var d=l("./zlib/deflate"),n=l("./utils/common"),r=l("./utils/strings"),u=l("./zlib/messages"),m=
l("./zlib/zstream"),x=Object.prototype.toString;h.prototype.push=function(f,k){var t=this.strm,C=this.options.chunkSize;if(this.ended)return!1;k=k===~~k?k:!0===k?4:0;"string"===typeof f?t.input=r.string2buf(f):"[object ArrayBuffer]"===x.call(f)?t.input=new Uint8Array(f):t.input=f;t.next_in=0;t.avail_in=t.input.length;do{0===t.avail_out&&(t.output=new n.Buf8(C),t.next_out=0,t.avail_out=C);f=d.deflate(t,k);if(1!==f&&0!==f)return this.onEnd(f),this.ended=!0,!1;if(0===t.avail_out||0===t.avail_in&&(4===
k||2===k))if("string"===this.options.to)this.onData(r.buf2binstring(n.shrinkBuf(t.output,t.next_out)));else this.onData(n.shrinkBuf(t.output,t.next_out))}while((0<t.avail_in||0===t.avail_out)&&1!==f);if(4===k)return f=d.deflateEnd(this.strm),this.onEnd(f),this.ended=!0,0===f;2===k&&(this.onEnd(0),t.avail_out=0);return!0};h.prototype.onData=function(f){this.chunks.push(f)};h.prototype.onEnd=function(f){0===f&&(this.result="string"===this.options.to?this.chunks.join(""):n.flattenChunks(this.chunks));
this.chunks=[];this.err=f;this.msg=this.strm.msg};y.Deflate=h;y.deflate=q;y.deflateRaw=function(f,k){k=k||{};k.raw=!0;return q(f,k)};y.gzip=function(f,k){k=k||{};k.gzip=!0;return q(f,k)}},{"./utils/common":62,"./utils/strings":63,"./zlib/deflate":67,"./zlib/messages":72,"./zlib/zstream":74}],61:[function(l,H,y){function h(t){if(!(this instanceof h))return new h(t);var C=this.options=n.assign({chunkSize:16384,windowBits:0,to:""},t||{});C.raw&&0<=C.windowBits&&16>C.windowBits&&(C.windowBits=-C.windowBits,
0===C.windowBits&&(C.windowBits=-15));!(0<=C.windowBits&&16>C.windowBits)||t&&t.windowBits||(C.windowBits+=32);15<C.windowBits&&48>C.windowBits&&0===(C.windowBits&15)&&(C.windowBits|=15);this.err=0;this.msg="";this.ended=!1;this.chunks=[];this.strm=new x;this.strm.avail_out=0;t=d.inflateInit2(this.strm,C.windowBits);if(t!==u.Z_OK)throw Error(m[t]);this.header=new f;d.inflateGetHeader(this.strm,this.header)}function q(t,C){C=new h(C);C.push(t,!0);if(C.err)throw C.msg||m[C.err];return C.result}var d=
l("./zlib/inflate"),n=l("./utils/common"),r=l("./utils/strings"),u=l("./zlib/constants"),m=l("./zlib/messages"),x=l("./zlib/zstream"),f=l("./zlib/gzheader"),k=Object.prototype.toString;h.prototype.push=function(t,C){var w=this.strm,p=this.options.chunkSize,v=this.options.dictionary,g=!1;if(this.ended)return!1;C=C===~~C?C:!0===C?u.Z_FINISH:u.Z_NO_FLUSH;"string"===typeof t?w.input=r.binstring2buf(t):"[object ArrayBuffer]"===k.call(t)?w.input=new Uint8Array(t):w.input=t;w.next_in=0;w.avail_in=w.input.length;
do{0===w.avail_out&&(w.output=new n.Buf8(p),w.next_out=0,w.avail_out=p);t=d.inflate(w,u.Z_NO_FLUSH);t===u.Z_NEED_DICT&&v&&(t="string"===typeof v?r.string2buf(v):"[object ArrayBuffer]"===k.call(v)?new Uint8Array(v):v,t=d.inflateSetDictionary(this.strm,t));t===u.Z_BUF_ERROR&&!0===g&&(t=u.Z_OK,g=!1);if(t!==u.Z_STREAM_END&&t!==u.Z_OK)return this.onEnd(t),this.ended=!0,!1;if(w.next_out&&(0===w.avail_out||t===u.Z_STREAM_END||0===w.avail_in&&(C===u.Z_FINISH||C===u.Z_SYNC_FLUSH)))if("string"===this.options.to){var F=
r.utf8border(w.output,w.next_out);var G=w.next_out-F;var I=r.buf2string(w.output,F);w.next_out=G;w.avail_out=p-G;G&&n.arraySet(w.output,w.output,F,G,0);this.onData(I)}else this.onData(n.shrinkBuf(w.output,w.next_out));0===w.avail_in&&0===w.avail_out&&(g=!0)}while((0<w.avail_in||0===w.avail_out)&&t!==u.Z_STREAM_END);t===u.Z_STREAM_END&&(C=u.Z_FINISH);if(C===u.Z_FINISH)return t=d.inflateEnd(this.strm),this.onEnd(t),this.ended=!0,t===u.Z_OK;C===u.Z_SYNC_FLUSH&&(this.onEnd(u.Z_OK),w.avail_out=0);return!0};
h.prototype.onData=function(t){this.chunks.push(t)};h.prototype.onEnd=function(t){t===u.Z_OK&&(this.result="string"===this.options.to?this.chunks.join(""):n.flattenChunks(this.chunks));this.chunks=[];this.err=t;this.msg=this.strm.msg};y.Inflate=h;y.inflate=q;y.inflateRaw=function(t,C){C=C||{};C.raw=!0;return q(t,C)};y.ungzip=q},{"./utils/common":62,"./utils/strings":63,"./zlib/constants":65,"./zlib/gzheader":68,"./zlib/inflate":70,"./zlib/messages":72,"./zlib/zstream":74}],62:[function(l,H,y){l="undefined"!==
typeof Uint8Array&&"undefined"!==typeof Uint16Array&&"undefined"!==typeof Int32Array;y.assign=function(d){for(var n=Array.prototype.slice.call(arguments,1);n.length;){var r=n.shift();if(r){if("object"!==typeof r)throw new TypeError(r+"must be non-object");for(var u in r)r.hasOwnProperty(u)&&(d[u]=r[u])}}return d};y.shrinkBuf=function(d,n){if(d.length===n)return d;if(d.subarray)return d.subarray(0,n);d.length=n;return d};var h={arraySet:function(d,n,r,u,m){if(n.subarray&&d.subarray)d.set(n.subarray(r,
r+u),m);else for(var x=0;x<u;x++)d[m+x]=n[r+x]},flattenChunks:function(d){var n,r;var u=r=0;for(n=d.length;u<n;u++)r+=d[u].length;var m=new Uint8Array(r);u=r=0;for(n=d.length;u<n;u++){var x=d[u];m.set(x,r);r+=x.length}return m}},q={arraySet:function(d,n,r,u,m){for(var x=0;x<u;x++)d[m+x]=n[r+x]},flattenChunks:function(d){return[].concat.apply([],d)}};y.setTyped=function(d){d?(y.Buf8=Uint8Array,y.Buf16=Uint16Array,y.Buf32=Int32Array,y.assign(y,h)):(y.Buf8=Array,y.Buf16=Array,y.Buf32=Array,y.assign(y,
q))};y.setTyped(l)},{}],63:[function(l,H,y){function h(u,m){if(65537>m&&(u.subarray&&n||!u.subarray&&d))return String.fromCharCode.apply(null,q.shrinkBuf(u,m));for(var x="",f=0;f<m;f++)x+=String.fromCharCode(u[f]);return x}var q=l("./common"),d=!0,n=!0;try{String.fromCharCode.apply(null,[0])}catch(u){d=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(u){n=!1}var r=new q.Buf8(256);for(l=0;256>l;l++)r[l]=252<=l?6:248<=l?5:240<=l?4:224<=l?3:192<=l?2:1;r[254]=r[254]=1;y.string2buf=function(u){var m,
x,f=u.length,k=0;for(m=0;m<f;m++){var t=u.charCodeAt(m);if(55296===(t&64512)&&m+1<f){var C=u.charCodeAt(m+1);56320===(C&64512)&&(t=65536+(t-55296<<10)+(C-56320),m++)}k+=128>t?1:2048>t?2:65536>t?3:4}var w=new q.Buf8(k);for(m=x=0;x<k;m++)t=u.charCodeAt(m),55296===(t&64512)&&m+1<f&&(C=u.charCodeAt(m+1),56320===(C&64512)&&(t=65536+(t-55296<<10)+(C-56320),m++)),128>t?w[x++]=t:(2048>t?w[x++]=192|t>>>6:(65536>t?w[x++]=224|t>>>12:(w[x++]=240|t>>>18,w[x++]=128|t>>>12&63),w[x++]=128|t>>>6&63),w[x++]=128|t&
63);return w};y.buf2binstring=function(u){return h(u,u.length)};y.binstring2buf=function(u){for(var m=new q.Buf8(u.length),x=0,f=m.length;x<f;x++)m[x]=u.charCodeAt(x);return m};y.buf2string=function(u,m){var x,f=m||u.length,k=Array(2*f);for(m=x=0;m<f;){var t=u[m++];if(128>t)k[x++]=t;else{var C=r[t];if(4<C)k[x++]=65533,m+=C-1;else{for(t&=2===C?31:3===C?15:7;1<C&&m<f;)t=t<<6|u[m++]&63,C--;1<C?k[x++]=65533:65536>t?k[x++]=t:(t-=65536,k[x++]=55296|t>>10&1023,k[x++]=56320|t&1023)}}}return h(k,x)};y.utf8border=
function(u,m){var x;m=m||u.length;m>u.length&&(m=u.length);for(x=m-1;0<=x&&128===(u[x]&192);)x--;return 0>x||0===x?m:x+r[u[x]]>m?x:m}},{"./common":62}],64:[function(l,H,y){H.exports=function(h,q,d,n){var r=h&65535|0;h=h>>>16&65535|0;for(var u;0!==d;){u=2E3<d?2E3:d;d-=u;do r=r+q[n++]|0,h=h+r|0;while(--u);r%=65521;h%=65521}return r|h<<16|0}},{}],65:[function(l,H,y){H.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,
Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],66:[function(l,H,y){var h=function(){for(var q,d=[],n=0;256>n;n++){q=n;for(var r=0;8>r;r++)q=q&1?3988292384^q>>>1:q>>>1;d[n]=q}return d}();H.exports=function(q,d,n,r){n=r+n;for(q^=-1;r<n;r++)q=q>>>8^h[(q^d[r])&255];return q^-1}},{}],67:[function(l,
H,y){function h(a,B){a.msg=N[B];return B}function q(a){for(var B=a.length;0<=--B;)a[B]=0}function d(a){var B=a.state,e=B.pending;e>a.avail_out&&(e=a.avail_out);0!==e&&(G.arraySet(a.output,B.pending_buf,B.pending_out,e,a.next_out),a.next_out+=e,B.pending_out+=e,a.total_out+=e,a.avail_out-=e,B.pending-=e,0===B.pending&&(B.pending_out=0))}function n(a,B){I._tr_flush_block(a,0<=a.block_start?a.block_start:-1,a.strstart-a.block_start,B);a.block_start=a.strstart;d(a.strm)}function r(a,B){a.pending_buf[a.pending++]=
B}function u(a,B){a.pending_buf[a.pending++]=B>>>8&255;a.pending_buf[a.pending++]=B&255}function m(a,B){var e=a.max_chain_length,A=a.strstart,z=a.prev_length,D=a.nice_match,T=a.strstart>a.w_size-262?a.strstart-(a.w_size-262):0,L=a.window,X=a.w_mask,O=a.prev,b=a.strstart+258,E=L[A+z-1],J=L[A+z];a.prev_length>=a.good_match&&(e>>=2);D>a.lookahead&&(D=a.lookahead);do{var M=B;if(L[M+z]===J&&L[M+z-1]===E&&L[M]===L[A]&&L[++M]===L[A+1]){A+=2;for(M++;L[++A]===L[++M]&&L[++A]===L[++M]&&L[++A]===L[++M]&&L[++A]===
L[++M]&&L[++A]===L[++M]&&L[++A]===L[++M]&&L[++A]===L[++M]&&L[++A]===L[++M]&&A<b;);M=258-(b-A);A=b-258;if(M>z){a.match_start=B;z=M;if(M>=D)break;E=L[A+z-1];J=L[A+z]}}}while((B=O[B&X])>T&&0!==--e);return z<=a.lookahead?z:a.lookahead}function x(a){var B=a.w_size,e;do{var A=a.window_size-a.lookahead-a.strstart;if(a.strstart>=B+(B-262)){G.arraySet(a.window,a.window,B,B,0);a.match_start-=B;a.strstart-=B;a.block_start-=B;var z=e=a.hash_size;do{var D=a.head[--z];a.head[z]=D>=B?D-B:0}while(--e);z=e=B;do D=
a.prev[--z],a.prev[z]=D>=B?D-B:0;while(--e);A+=B}if(0===a.strm.avail_in)break;z=a.strm;e=a.window;D=a.strstart+a.lookahead;var T=z.avail_in;T>A&&(T=A);0===T?e=0:(z.avail_in-=T,G.arraySet(e,z.input,z.next_in,T,D),1===z.state.wrap?z.adler=K(z.adler,e,T,D):2===z.state.wrap&&(z.adler=c(z.adler,e,T,D)),z.next_in+=T,z.total_in+=T,e=T);a.lookahead+=e;if(3<=a.lookahead+a.insert)for(A=a.strstart-a.insert,a.ins_h=a.window[A],a.ins_h=(a.ins_h<<a.hash_shift^a.window[A+1])&a.hash_mask;a.insert&&!(a.ins_h=(a.ins_h<<
a.hash_shift^a.window[A+3-1])&a.hash_mask,a.prev[A&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=A,A++,a.insert--,3>a.lookahead+a.insert););}while(262>a.lookahead&&0!==a.strm.avail_in)}function f(a,B){for(var e;;){if(262>a.lookahead){x(a);if(262>a.lookahead&&0===B)return 1;if(0===a.lookahead)break}e=0;3<=a.lookahead&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,e=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart);0!==e&&a.strstart-e<=a.w_size-262&&(a.match_length=
m(a,e));if(3<=a.match_length)if(e=I._tr_tally(a,a.strstart-a.match_start,a.match_length-3),a.lookahead-=a.match_length,a.match_length<=a.max_lazy_match&&3<=a.lookahead){a.match_length--;do a.strstart++,a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart;while(0!==--a.match_length);a.strstart++}else a.strstart+=a.match_length,a.match_length=0,a.ins_h=a.window[a.strstart],a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+
1])&a.hash_mask;else e=I._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++;if(e&&(n(a,!1),0===a.strm.avail_out))return 1}a.insert=2>a.strstart?a.strstart:2;return 4===B?(n(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(n(a,!1),0===a.strm.avail_out)?1:2}function k(a,B){for(var e,A;;){if(262>a.lookahead){x(a);if(262>a.lookahead&&0===B)return 1;if(0===a.lookahead)break}e=0;3<=a.lookahead&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,e=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],
a.head[a.ins_h]=a.strstart);a.prev_length=a.match_length;a.prev_match=a.match_start;a.match_length=2;0!==e&&a.prev_length<a.max_lazy_match&&a.strstart-e<=a.w_size-262&&(a.match_length=m(a,e),5>=a.match_length&&(1===a.strategy||3===a.match_length&&4096<a.strstart-a.match_start)&&(a.match_length=2));if(3<=a.prev_length&&a.match_length<=a.prev_length){A=a.strstart+a.lookahead-3;e=I._tr_tally(a,a.strstart-1-a.prev_match,a.prev_length-3);a.lookahead-=a.prev_length-1;a.prev_length-=2;do++a.strstart<=A&&
(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart);while(0!==--a.prev_length);a.match_available=0;a.match_length=2;a.strstart++;if(e&&(n(a,!1),0===a.strm.avail_out))return 1}else if(a.match_available){if((e=I._tr_tally(a,0,a.window[a.strstart-1]))&&n(a,!1),a.strstart++,a.lookahead--,0===a.strm.avail_out)return 1}else a.match_available=1,a.strstart++,a.lookahead--}a.match_available&&(I._tr_tally(a,0,a.window[a.strstart-
1]),a.match_available=0);a.insert=2>a.strstart?a.strstart:2;return 4===B?(n(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(n(a,!1),0===a.strm.avail_out)?1:2}function t(a,B){for(var e,A,z,D=a.window;;){if(258>=a.lookahead){x(a);if(258>=a.lookahead&&0===B)return 1;if(0===a.lookahead)break}a.match_length=0;if(3<=a.lookahead&&0<a.strstart&&(A=a.strstart-1,e=D[A],e===D[++A]&&e===D[++A]&&e===D[++A])){for(z=a.strstart+258;e===D[++A]&&e===D[++A]&&e===D[++A]&&e===D[++A]&&e===D[++A]&&e===D[++A]&&e===D[++A]&&
e===D[++A]&&A<z;);a.match_length=258-(z-A);a.match_length>a.lookahead&&(a.match_length=a.lookahead)}3<=a.match_length?(e=I._tr_tally(a,1,a.match_length-3),a.lookahead-=a.match_length,a.strstart+=a.match_length,a.match_length=0):(e=I._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++);if(e&&(n(a,!1),0===a.strm.avail_out))return 1}a.insert=0;return 4===B?(n(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(n(a,!1),0===a.strm.avail_out)?1:2}function C(a,B){for(var e;;){if(0===a.lookahead&&(x(a),
0===a.lookahead)){if(0===B)return 1;break}a.match_length=0;e=I._tr_tally(a,0,a.window[a.strstart]);a.lookahead--;a.strstart++;if(e&&(n(a,!1),0===a.strm.avail_out))return 1}a.insert=0;return 4===B?(n(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(n(a,!1),0===a.strm.avail_out)?1:2}function w(a,B,e,A,z){this.good_length=a;this.max_lazy=B;this.nice_length=e;this.max_chain=A;this.func=z}function p(){this.strm=null;this.status=0;this.pending_buf=null;this.wrap=this.pending=this.pending_out=this.pending_buf_size=
0;this.gzhead=null;this.gzindex=0;this.method=8;this.last_flush=-1;this.w_mask=this.w_bits=this.w_size=0;this.window=null;this.window_size=0;this.head=this.prev=null;this.nice_match=this.good_match=this.strategy=this.level=this.max_lazy_match=this.max_chain_length=this.prev_length=this.lookahead=this.match_start=this.strstart=this.match_available=this.prev_match=this.match_length=this.block_start=this.hash_shift=this.hash_mask=this.hash_bits=this.hash_size=this.ins_h=0;this.dyn_ltree=new G.Buf16(1146);
this.dyn_dtree=new G.Buf16(122);this.bl_tree=new G.Buf16(78);q(this.dyn_ltree);q(this.dyn_dtree);q(this.bl_tree);this.bl_desc=this.d_desc=this.l_desc=null;this.bl_count=new G.Buf16(16);this.heap=new G.Buf16(573);q(this.heap);this.heap_max=this.heap_len=0;this.depth=new G.Buf16(573);q(this.depth);this.bi_valid=this.bi_buf=this.insert=this.matches=this.static_len=this.opt_len=this.d_buf=this.last_lit=this.lit_bufsize=this.l_buf=0}function v(a){if(!a||!a.state)return h(a,-2);a.total_in=a.total_out=0;
a.data_type=2;var B=a.state;B.pending=0;B.pending_out=0;0>B.wrap&&(B.wrap=-B.wrap);B.status=B.wrap?42:113;a.adler=2===B.wrap?0:1;B.last_flush=0;I._tr_init(B);return 0}function g(a){var B=v(a);0===B&&(a=a.state,a.window_size=2*a.w_size,q(a.head),a.max_lazy_match=P[a.level].max_lazy,a.good_match=P[a.level].good_length,a.nice_match=P[a.level].nice_length,a.max_chain_length=P[a.level].max_chain,a.strstart=0,a.block_start=0,a.lookahead=0,a.insert=0,a.match_length=a.prev_length=2,a.match_available=0,a.ins_h=
0);return B}function F(a,B,e,A,z,D){if(!a)return-2;var T=1;-1===B&&(B=6);0>A?(T=0,A=-A):15<A&&(T=2,A-=16);if(1>z||9<z||8!==e||8>A||15<A||0>B||9<B||0>D||4<D)return h(a,-2);8===A&&(A=9);var L=new p;a.state=L;L.strm=a;L.wrap=T;L.gzhead=null;L.w_bits=A;L.w_size=1<<L.w_bits;L.w_mask=L.w_size-1;L.hash_bits=z+7;L.hash_size=1<<L.hash_bits;L.hash_mask=L.hash_size-1;L.hash_shift=~~((L.hash_bits+3-1)/3);L.window=new G.Buf8(2*L.w_size);L.head=new G.Buf16(L.hash_size);L.prev=new G.Buf16(L.w_size);L.lit_bufsize=
1<<z+6;L.pending_buf_size=4*L.lit_bufsize;L.pending_buf=new G.Buf8(L.pending_buf_size);L.d_buf=1*L.lit_bufsize;L.l_buf=3*L.lit_bufsize;L.level=B;L.strategy=D;L.method=e;return g(a)}var G=l("../utils/common"),I=l("./trees"),K=l("./adler32"),c=l("./crc32"),N=l("./messages");var P=[new w(0,0,0,0,function(a,B){var e=65535;for(e>a.pending_buf_size-5&&(e=a.pending_buf_size-5);;){if(1>=a.lookahead){x(a);if(0===a.lookahead&&0===B)return 1;if(0===a.lookahead)break}a.strstart+=a.lookahead;a.lookahead=0;var A=
a.block_start+e;if(0===a.strstart||a.strstart>=A)if(a.lookahead=a.strstart-A,a.strstart=A,n(a,!1),0===a.strm.avail_out)return 1;if(a.strstart-a.block_start>=a.w_size-262&&(n(a,!1),0===a.strm.avail_out))return 1}a.insert=0;if(4===B)return n(a,!0),0===a.strm.avail_out?3:4;a.strstart>a.block_start&&n(a,!1);return 1}),new w(4,4,8,4,f),new w(4,5,16,8,f),new w(4,6,32,32,f),new w(4,4,16,16,k),new w(8,16,32,32,k),new w(8,16,128,128,k),new w(8,32,128,256,k),new w(32,128,258,1024,k),new w(32,258,258,4096,k)];
y.deflateInit=function(a,B){return F(a,B,8,15,8,0)};y.deflateInit2=F;y.deflateReset=g;y.deflateResetKeep=v;y.deflateSetHeader=function(a,B){if(!a||!a.state||2!==a.state.wrap)return-2;a.state.gzhead=B;return 0};y.deflate=function(a,B){if(!a||!a.state||5<B||0>B)return a?h(a,-2):-2;var e=a.state;if(!a.output||!a.input&&0!==a.avail_in||666===e.status&&4!==B)return h(a,0===a.avail_out?-5:-2);e.strm=a;var A=e.last_flush;e.last_flush=B;if(42===e.status)if(2===e.wrap)a.adler=0,r(e,31),r(e,139),r(e,8),e.gzhead?
(r(e,(e.gzhead.text?1:0)+(e.gzhead.hcrc?2:0)+(e.gzhead.extra?4:0)+(e.gzhead.name?8:0)+(e.gzhead.comment?16:0)),r(e,e.gzhead.time&255),r(e,e.gzhead.time>>8&255),r(e,e.gzhead.time>>16&255),r(e,e.gzhead.time>>24&255),r(e,9===e.level?2:2<=e.strategy||2>e.level?4:0),r(e,e.gzhead.os&255),e.gzhead.extra&&e.gzhead.extra.length&&(r(e,e.gzhead.extra.length&255),r(e,e.gzhead.extra.length>>8&255)),e.gzhead.hcrc&&(a.adler=c(a.adler,e.pending_buf,e.pending,0)),e.gzindex=0,e.status=69):(r(e,0),r(e,0),r(e,0),r(e,
0),r(e,0),r(e,9===e.level?2:2<=e.strategy||2>e.level?4:0),r(e,3),e.status=113);else{var z=8+(e.w_bits-8<<4)<<8;z|=(2<=e.strategy||2>e.level?0:6>e.level?1:6===e.level?2:3)<<6;0!==e.strstart&&(z|=32);e.status=113;u(e,z+(31-z%31));0!==e.strstart&&(u(e,a.adler>>>16),u(e,a.adler&65535));a.adler=1}if(69===e.status)if(e.gzhead.extra){for(z=e.pending;e.gzindex<(e.gzhead.extra.length&65535)&&(e.pending!==e.pending_buf_size||(e.gzhead.hcrc&&e.pending>z&&(a.adler=c(a.adler,e.pending_buf,e.pending-z,z)),d(a),
z=e.pending,e.pending!==e.pending_buf_size));)r(e,e.gzhead.extra[e.gzindex]&255),e.gzindex++;e.gzhead.hcrc&&e.pending>z&&(a.adler=c(a.adler,e.pending_buf,e.pending-z,z));e.gzindex===e.gzhead.extra.length&&(e.gzindex=0,e.status=73)}else e.status=73;if(73===e.status)if(e.gzhead.name){z=e.pending;do{if(e.pending===e.pending_buf_size&&(e.gzhead.hcrc&&e.pending>z&&(a.adler=c(a.adler,e.pending_buf,e.pending-z,z)),d(a),z=e.pending,e.pending===e.pending_buf_size)){var D=1;break}D=e.gzindex<e.gzhead.name.length?
e.gzhead.name.charCodeAt(e.gzindex++)&255:0;r(e,D)}while(0!==D);e.gzhead.hcrc&&e.pending>z&&(a.adler=c(a.adler,e.pending_buf,e.pending-z,z));0===D&&(e.gzindex=0,e.status=91)}else e.status=91;if(91===e.status)if(e.gzhead.comment){z=e.pending;do{if(e.pending===e.pending_buf_size&&(e.gzhead.hcrc&&e.pending>z&&(a.adler=c(a.adler,e.pending_buf,e.pending-z,z)),d(a),z=e.pending,e.pending===e.pending_buf_size)){D=1;break}D=e.gzindex<e.gzhead.comment.length?e.gzhead.comment.charCodeAt(e.gzindex++)&255:0;r(e,
D)}while(0!==D);e.gzhead.hcrc&&e.pending>z&&(a.adler=c(a.adler,e.pending_buf,e.pending-z,z));0===D&&(e.status=103)}else e.status=103;103===e.status&&(e.gzhead.hcrc?(e.pending+2>e.pending_buf_size&&d(a),e.pending+2<=e.pending_buf_size&&(r(e,a.adler&255),r(e,a.adler>>8&255),a.adler=0,e.status=113)):e.status=113);if(0!==e.pending){if(d(a),0===a.avail_out)return e.last_flush=-1,0}else if(0===a.avail_in&&(B<<1)-(4<B?9:0)<=(A<<1)-(4<A?9:0)&&4!==B)return h(a,-5);if(666===e.status&&0!==a.avail_in)return h(a,
-5);if(0!==a.avail_in||0!==e.lookahead||0!==B&&666!==e.status){A=2===e.strategy?C(e,B):3===e.strategy?t(e,B):P[e.level].func(e,B);if(3===A||4===A)e.status=666;if(1===A||3===A)return 0===a.avail_out&&(e.last_flush=-1),0;if(2===A&&(1===B?I._tr_align(e):5!==B&&(I._tr_stored_block(e,0,0,!1),3===B&&(q(e.head),0===e.lookahead&&(e.strstart=0,e.block_start=0,e.insert=0))),d(a),0===a.avail_out))return e.last_flush=-1,0}if(4!==B)return 0;if(0>=e.wrap)return 1;2===e.wrap?(r(e,a.adler&255),r(e,a.adler>>8&255),
r(e,a.adler>>16&255),r(e,a.adler>>24&255),r(e,a.total_in&255),r(e,a.total_in>>8&255),r(e,a.total_in>>16&255),r(e,a.total_in>>24&255)):(u(e,a.adler>>>16),u(e,a.adler&65535));d(a);0<e.wrap&&(e.wrap=-e.wrap);return 0!==e.pending?0:1};y.deflateEnd=function(a){if(!a||!a.state)return-2;var B=a.state.status;if(42!==B&&69!==B&&73!==B&&91!==B&&103!==B&&113!==B&&666!==B)return h(a,-2);a.state=null;return 113===B?h(a,-3):0};y.deflateSetDictionary=function(a,B){var e=B.length;if(!a||!a.state)return-2;var A=a.state;
var z=A.wrap;if(2===z||1===z&&42!==A.status||A.lookahead)return-2;1===z&&(a.adler=K(a.adler,B,e,0));A.wrap=0;if(e>=A.w_size){0===z&&(q(A.head),A.strstart=0,A.block_start=0,A.insert=0);var D=new G.Buf8(A.w_size);G.arraySet(D,B,e-A.w_size,A.w_size,0);B=D;e=A.w_size}D=a.avail_in;var T=a.next_in;var L=a.input;a.avail_in=e;a.next_in=0;a.input=B;for(x(A);3<=A.lookahead;){B=A.strstart;e=A.lookahead-2;do A.ins_h=(A.ins_h<<A.hash_shift^A.window[B+3-1])&A.hash_mask,A.prev[B&A.w_mask]=A.head[A.ins_h],A.head[A.ins_h]=
B,B++;while(--e);A.strstart=B;A.lookahead=2;x(A)}A.strstart+=A.lookahead;A.block_start=A.strstart;A.insert=A.lookahead;A.lookahead=0;A.match_length=A.prev_length=2;A.match_available=0;a.next_in=T;a.input=L;a.avail_in=D;A.wrap=z;return 0};y.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":62,"./adler32":64,"./crc32":66,"./messages":72,"./trees":73}],68:[function(l,H,y){H.exports=function(){this.os=this.xflags=this.time=this.text=0;this.extra=null;this.extra_len=0;this.comment=this.name=
"";this.hcrc=0;this.done=!1}},{}],69:[function(l,H,y){H.exports=function(h,q){var d=h.state;var n=h.next_in;var r=h.input;var u=n+(h.avail_in-5);var m=h.next_out;var x=h.output;q=m-(q-h.avail_out);var f=m+(h.avail_out-257);var k=d.dmax;var t=d.wsize;var C=d.whave;var w=d.wnext;var p=d.window;var v=d.hold;var g=d.bits;var F=d.lencode;var G=d.distcode;var I=(1<<d.lenbits)-1;var K=(1<<d.distbits)-1;a:do{15>g&&(v+=r[n++]<<g,g+=8,v+=r[n++]<<g,g+=8);var c=F[v&I];b:for(;;){var N=c>>>24;v>>>=N;g-=N;N=c>>>
16&255;if(0===N)x[m++]=c&65535;else if(N&16){var P=c&65535;if(N&=15)g<N&&(v+=r[n++]<<g,g+=8),P+=v&(1<<N)-1,v>>>=N,g-=N;15>g&&(v+=r[n++]<<g,g+=8,v+=r[n++]<<g,g+=8);c=G[v&K];c:for(;;){N=c>>>24;v>>>=N;g-=N;N=c>>>16&255;if(N&16){c&=65535;N&=15;g<N&&(v+=r[n++]<<g,g+=8,g<N&&(v+=r[n++]<<g,g+=8));c+=v&(1<<N)-1;if(c>k){h.msg="invalid distance too far back";d.mode=30;break a}v>>>=N;g-=N;N=m-q;if(c>N){N=c-N;if(N>C&&d.sane){h.msg="invalid distance too far back";d.mode=30;break a}var a=0;var B=p;if(0===w){if(a+=
t-N,N<P){P-=N;do x[m++]=p[a++];while(--N);a=m-c;B=x}}else if(w<N){if(a+=t+w-N,N-=w,N<P){P-=N;do x[m++]=p[a++];while(--N);a=0;if(w<P){N=w;P-=N;do x[m++]=p[a++];while(--N);a=m-c;B=x}}}else if(a+=w-N,N<P){P-=N;do x[m++]=p[a++];while(--N);a=m-c;B=x}for(;2<P;)x[m++]=B[a++],x[m++]=B[a++],x[m++]=B[a++],P-=3;P&&(x[m++]=B[a++],1<P&&(x[m++]=B[a++]))}else{a=m-c;do x[m++]=x[a++],x[m++]=x[a++],x[m++]=x[a++],P-=3;while(2<P);P&&(x[m++]=x[a++],1<P&&(x[m++]=x[a++]))}}else if(0===(N&64)){c=G[(c&65535)+(v&(1<<N)-1)];
continue c}else{h.msg="invalid distance code";d.mode=30;break a}break}}else if(0===(N&64)){c=F[(c&65535)+(v&(1<<N)-1)];continue b}else{N&32?d.mode=12:(h.msg="invalid literal/length code",d.mode=30);break a}break}}while(n<u&&m<f);P=g>>3;n-=P;g-=P<<3;h.next_in=n;h.next_out=m;h.avail_in=n<u?5+(u-n):5-(n-u);h.avail_out=m<f?257+(f-m):257-(m-f);d.hold=v&(1<<g)-1;d.bits=g}},{}],70:[function(l,H,y){function h(g){return(g>>>24&255)+(g>>>8&65280)+((g&65280)<<8)+((g&255)<<24)}function q(){this.mode=0;this.last=
!1;this.wrap=0;this.havedict=!1;this.total=this.check=this.dmax=this.flags=0;this.head=null;this.wnext=this.whave=this.wsize=this.wbits=0;this.window=null;this.extra=this.offset=this.length=this.bits=this.hold=0;this.distcode=this.lencode=null;this.have=this.ndist=this.nlen=this.ncode=this.distbits=this.lenbits=0;this.next=null;this.lens=new x.Buf16(320);this.work=new x.Buf16(288);this.distdyn=this.lendyn=null;this.was=this.back=this.sane=0}function d(g){if(!g||!g.state)return-2;var F=g.state;g.total_in=
g.total_out=F.total=0;g.msg="";F.wrap&&(g.adler=F.wrap&1);F.mode=1;F.last=0;F.havedict=0;F.dmax=32768;F.head=null;F.hold=0;F.bits=0;F.lencode=F.lendyn=new x.Buf32(852);F.distcode=F.distdyn=new x.Buf32(592);F.sane=1;F.back=-1;return 0}function n(g){if(!g||!g.state)return-2;var F=g.state;F.wsize=0;F.whave=0;F.wnext=0;return d(g)}function r(g,F){if(!g||!g.state)return-2;var G=g.state;if(0>F){var I=0;F=-F}else I=(F>>4)+1,48>F&&(F&=15);if(F&&(8>F||15<F))return-2;null!==G.window&&G.wbits!==F&&(G.window=
null);G.wrap=I;G.wbits=F;return n(g)}function u(g,F){if(!g)return-2;var G=new q;g.state=G;G.window=null;F=r(g,F);0!==F&&(g.state=null);return F}function m(g,F,G,I){var K=g.state;null===K.window&&(K.wsize=1<<K.wbits,K.wnext=0,K.whave=0,K.window=new x.Buf8(K.wsize));I>=K.wsize?(x.arraySet(K.window,F,G-K.wsize,K.wsize,0),K.wnext=0,K.whave=K.wsize):(g=K.wsize-K.wnext,g>I&&(g=I),x.arraySet(K.window,F,G-I,g,K.wnext),(I-=g)?(x.arraySet(K.window,F,G-I,I,0),K.wnext=I,K.whave=K.wsize):(K.wnext+=g,K.wnext===
K.wsize&&(K.wnext=0),K.whave<K.wsize&&(K.whave+=g)));return 0}var x=l("../utils/common"),f=l("./adler32"),k=l("./crc32"),t=l("./inffast"),C=l("./inftrees"),w=!0,p,v;y.inflateReset=n;y.inflateReset2=r;y.inflateResetKeep=d;y.inflateInit=function(g){return u(g,15)};y.inflateInit2=u;y.inflate=function(g,F){var G,I=new x.Buf8(4),K=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!g||!g.state||!g.output||!g.input&&0!==g.avail_in)return-2;var c=g.state;12===c.mode&&(c.mode=13);var N=g.next_out;var P=
g.output;var a=g.avail_out;var B=g.next_in;var e=g.input;var A=g.avail_in;var z=c.hold;var D=c.bits;var T=A;var L=a;var X=0;a:for(;;)switch(c.mode){case 1:if(0===c.wrap){c.mode=13;break}for(;16>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}if(c.wrap&2&&35615===z){c.check=0;I[0]=z&255;I[1]=z>>>8&255;c.check=k(c.check,I,2,0);D=z=0;c.mode=2;break}c.flags=0;c.head&&(c.head.done=!1);if(!(c.wrap&1)||(((z&255)<<8)+(z>>8))%31){g.msg="incorrect header check";c.mode=30;break}if(8!==(z&15)){g.msg="unknown compression method";
c.mode=30;break}z>>>=4;D-=4;var O=(z&15)+8;if(0===c.wbits)c.wbits=O;else if(O>c.wbits){g.msg="invalid window size";c.mode=30;break}c.dmax=1<<O;g.adler=c.check=1;c.mode=z&512?10:12;D=z=0;break;case 2:for(;16>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.flags=z;if(8!==(c.flags&255)){g.msg="unknown compression method";c.mode=30;break}if(c.flags&57344){g.msg="unknown header flags set";c.mode=30;break}c.head&&(c.head.text=z>>8&1);c.flags&512&&(I[0]=z&255,I[1]=z>>>8&255,c.check=k(c.check,I,2,0));D=z=0;
c.mode=3;case 3:for(;32>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.head&&(c.head.time=z);c.flags&512&&(I[0]=z&255,I[1]=z>>>8&255,I[2]=z>>>16&255,I[3]=z>>>24&255,c.check=k(c.check,I,4,0));D=z=0;c.mode=4;case 4:for(;16>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.head&&(c.head.xflags=z&255,c.head.os=z>>8);c.flags&512&&(I[0]=z&255,I[1]=z>>>8&255,c.check=k(c.check,I,2,0));D=z=0;c.mode=5;case 5:if(c.flags&1024){for(;16>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.length=z;c.head&&(c.head.extra_len=z);
c.flags&512&&(I[0]=z&255,I[1]=z>>>8&255,c.check=k(c.check,I,2,0));D=z=0}else c.head&&(c.head.extra=null);c.mode=6;case 6:if(c.flags&1024){var b=c.length;b>A&&(b=A);b&&(c.head&&(O=c.head.extra_len-c.length,c.head.extra||(c.head.extra=Array(c.head.extra_len)),x.arraySet(c.head.extra,e,B,b,O)),c.flags&512&&(c.check=k(c.check,e,b,B)),A-=b,B+=b,c.length-=b);if(c.length)break a}c.length=0;c.mode=7;case 7:if(c.flags&2048){if(0===A)break a;b=0;do O=e[B+b++],c.head&&O&&65536>c.length&&(c.head.name+=String.fromCharCode(O));
while(O&&b<A);c.flags&512&&(c.check=k(c.check,e,b,B));A-=b;B+=b;if(O)break a}else c.head&&(c.head.name=null);c.length=0;c.mode=8;case 8:if(c.flags&4096){if(0===A)break a;b=0;do O=e[B+b++],c.head&&O&&65536>c.length&&(c.head.comment+=String.fromCharCode(O));while(O&&b<A);c.flags&512&&(c.check=k(c.check,e,b,B));A-=b;B+=b;if(O)break a}else c.head&&(c.head.comment=null);c.mode=9;case 9:if(c.flags&512){for(;16>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}if(z!==(c.check&65535)){g.msg="header crc mismatch";
c.mode=30;break}D=z=0}c.head&&(c.head.hcrc=c.flags>>9&1,c.head.done=!0);g.adler=c.check=0;c.mode=12;break;case 10:for(;32>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}g.adler=c.check=h(z);D=z=0;c.mode=11;case 11:if(0===c.havedict)return g.next_out=N,g.avail_out=a,g.next_in=B,g.avail_in=A,c.hold=z,c.bits=D,2;g.adler=c.check=1;c.mode=12;case 12:if(5===F||6===F)break a;case 13:if(c.last){z>>>=D&7;D-=D&7;c.mode=27;break}for(;3>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.last=z&1;z>>>=1;--D;switch(z&3){case 0:c.mode=
14;break;case 1:O=c;if(w){p=new x.Buf32(512);v=new x.Buf32(32);for(b=0;144>b;)O.lens[b++]=8;for(;256>b;)O.lens[b++]=9;for(;280>b;)O.lens[b++]=7;for(;288>b;)O.lens[b++]=8;C(1,O.lens,0,288,p,0,O.work,{bits:9});for(b=0;32>b;)O.lens[b++]=5;C(2,O.lens,0,32,v,0,O.work,{bits:5});w=!1}O.lencode=p;O.lenbits=9;O.distcode=v;O.distbits=5;c.mode=20;if(6===F){z>>>=2;D-=2;break a}break;case 2:c.mode=17;break;case 3:g.msg="invalid block type",c.mode=30}z>>>=2;D-=2;break;case 14:z>>>=D&7;for(D-=D&7;32>D;){if(0===
A)break a;A--;z+=e[B++]<<D;D+=8}if((z&65535)!==(z>>>16^65535)){g.msg="invalid stored block lengths";c.mode=30;break}c.length=z&65535;D=z=0;c.mode=15;if(6===F)break a;case 15:c.mode=16;case 16:if(b=c.length){b>A&&(b=A);b>a&&(b=a);if(0===b)break a;x.arraySet(P,e,B,b,N);A-=b;B+=b;a-=b;N+=b;c.length-=b;break}c.mode=12;break;case 17:for(;14>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.nlen=(z&31)+257;z>>>=5;D-=5;c.ndist=(z&31)+1;z>>>=5;D-=5;c.ncode=(z&15)+4;z>>>=4;D-=4;if(286<c.nlen||30<c.ndist){g.msg=
"too many length or distance symbols";c.mode=30;break}c.have=0;c.mode=18;case 18:for(;c.have<c.ncode;){for(;3>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.lens[K[c.have++]]=z&7;z>>>=3;D-=3}for(;19>c.have;)c.lens[K[c.have++]]=0;c.lencode=c.lendyn;c.lenbits=7;b={bits:c.lenbits};X=C(0,c.lens,0,19,c.lencode,0,c.work,b);c.lenbits=b.bits;if(X){g.msg="invalid code lengths set";c.mode=30;break}c.have=0;c.mode=19;case 19:for(;c.have<c.nlen+c.ndist;){for(;;){var E=c.lencode[z&(1<<c.lenbits)-1];b=E>>>24;E&=
65535;if(b<=D)break;if(0===A)break a;A--;z+=e[B++]<<D;D+=8}if(16>E)z>>>=b,D-=b,c.lens[c.have++]=E;else{if(16===E){for(O=b+2;D<O;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}z>>>=b;D-=b;if(0===c.have){g.msg="invalid bit length repeat";c.mode=30;break}O=c.lens[c.have-1];b=3+(z&3);z>>>=2;D-=2}else if(17===E){for(O=b+3;D<O;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}z>>>=b;D-=b;O=0;b=3+(z&7);z>>>=3;D-=3}else{for(O=b+7;D<O;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}z>>>=b;D-=b;O=0;b=11+(z&127);z>>>=7;D-=7}if(c.have+
b>c.nlen+c.ndist){g.msg="invalid bit length repeat";c.mode=30;break}for(;b--;)c.lens[c.have++]=O}}if(30===c.mode)break;if(0===c.lens[256]){g.msg="invalid code -- missing end-of-block";c.mode=30;break}c.lenbits=9;b={bits:c.lenbits};X=C(1,c.lens,0,c.nlen,c.lencode,0,c.work,b);c.lenbits=b.bits;if(X){g.msg="invalid literal/lengths set";c.mode=30;break}c.distbits=6;c.distcode=c.distdyn;b={bits:c.distbits};X=C(2,c.lens,c.nlen,c.ndist,c.distcode,0,c.work,b);c.distbits=b.bits;if(X){g.msg="invalid distances set";
c.mode=30;break}c.mode=20;if(6===F)break a;case 20:c.mode=21;case 21:if(6<=A&&258<=a){g.next_out=N;g.avail_out=a;g.next_in=B;g.avail_in=A;c.hold=z;c.bits=D;t(g,L);N=g.next_out;P=g.output;a=g.avail_out;B=g.next_in;e=g.input;A=g.avail_in;z=c.hold;D=c.bits;12===c.mode&&(c.back=-1);break}for(c.back=0;;){E=c.lencode[z&(1<<c.lenbits)-1];b=E>>>24;O=E>>>16&255;E&=65535;if(b<=D)break;if(0===A)break a;A--;z+=e[B++]<<D;D+=8}if(O&&0===(O&240)){var J=b;var M=O;for(G=E;;){E=c.lencode[G+((z&(1<<J+M)-1)>>J)];b=E>>>
24;O=E>>>16&255;E&=65535;if(J+b<=D)break;if(0===A)break a;A--;z+=e[B++]<<D;D+=8}z>>>=J;D-=J;c.back+=J}z>>>=b;D-=b;c.back+=b;c.length=E;if(0===O){c.mode=26;break}if(O&32){c.back=-1;c.mode=12;break}if(O&64){g.msg="invalid literal/length code";c.mode=30;break}c.extra=O&15;c.mode=22;case 22:if(c.extra){for(O=c.extra;D<O;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.length+=z&(1<<c.extra)-1;z>>>=c.extra;D-=c.extra;c.back+=c.extra}c.was=c.length;c.mode=23;case 23:for(;;){E=c.distcode[z&(1<<c.distbits)-1];
b=E>>>24;O=E>>>16&255;E&=65535;if(b<=D)break;if(0===A)break a;A--;z+=e[B++]<<D;D+=8}if(0===(O&240)){J=b;M=O;for(G=E;;){E=c.distcode[G+((z&(1<<J+M)-1)>>J)];b=E>>>24;O=E>>>16&255;E&=65535;if(J+b<=D)break;if(0===A)break a;A--;z+=e[B++]<<D;D+=8}z>>>=J;D-=J;c.back+=J}z>>>=b;D-=b;c.back+=b;if(O&64){g.msg="invalid distance code";c.mode=30;break}c.offset=E;c.extra=O&15;c.mode=24;case 24:if(c.extra){for(O=c.extra;D<O;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}c.offset+=z&(1<<c.extra)-1;z>>>=c.extra;D-=c.extra;
c.back+=c.extra}if(c.offset>c.dmax){g.msg="invalid distance too far back";c.mode=30;break}c.mode=25;case 25:if(0===a)break a;b=L-a;if(c.offset>b){b=c.offset-b;if(b>c.whave&&c.sane){g.msg="invalid distance too far back";c.mode=30;break}b>c.wnext?(b-=c.wnext,O=c.wsize-b):O=c.wnext-b;b>c.length&&(b=c.length);J=c.window}else J=P,O=N-c.offset,b=c.length;b>a&&(b=a);a-=b;c.length-=b;do P[N++]=J[O++];while(--b);0===c.length&&(c.mode=21);break;case 26:if(0===a)break a;P[N++]=c.length;a--;c.mode=21;break;case 27:if(c.wrap){for(;32>
D;){if(0===A)break a;A--;z|=e[B++]<<D;D+=8}L-=a;g.total_out+=L;c.total+=L;L&&(g.adler=c.check=c.flags?k(c.check,P,L,N-L):f(c.check,P,L,N-L));L=a;if((c.flags?z:h(z))!==c.check){g.msg="incorrect data check";c.mode=30;break}D=z=0}c.mode=28;case 28:if(c.wrap&&c.flags){for(;32>D;){if(0===A)break a;A--;z+=e[B++]<<D;D+=8}if(z!==(c.total&4294967295)){g.msg="incorrect length check";c.mode=30;break}D=z=0}c.mode=29;case 29:X=1;break a;case 30:X=-3;break a;case 31:return-4;default:return-2}g.next_out=N;g.avail_out=
a;g.next_in=B;g.avail_in=A;c.hold=z;c.bits=D;if((c.wsize||L!==g.avail_out&&30>c.mode&&(27>c.mode||4!==F))&&m(g,g.output,g.next_out,L-g.avail_out))return c.mode=31,-4;T-=g.avail_in;L-=g.avail_out;g.total_in+=T;g.total_out+=L;c.total+=L;c.wrap&&L&&(g.adler=c.check=c.flags?k(c.check,P,L,g.next_out-L):f(c.check,P,L,g.next_out-L));g.data_type=c.bits+(c.last?64:0)+(12===c.mode?128:0)+(20===c.mode||15===c.mode?256:0);(0===T&&0===L||4===F)&&0===X&&(X=-5);return X};y.inflateEnd=function(g){if(!g||!g.state)return-2;
var F=g.state;F.window&&(F.window=null);g.state=null;return 0};y.inflateGetHeader=function(g,F){if(!g||!g.state)return-2;g=g.state;if(0===(g.wrap&2))return-2;g.head=F;F.done=!1;return 0};y.inflateSetDictionary=function(g,F){var G=F.length;if(!g||!g.state)return-2;var I=g.state;if(0!==I.wrap&&11!==I.mode)return-2;if(11===I.mode){var K=f(1,F,G,0);if(K!==I.check)return-3}if(m(g,F,G,G))return I.mode=31,-4;I.havedict=1;return 0};y.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":62,
"./adler32":64,"./crc32":66,"./inffast":69,"./inftrees":71}],71:[function(l,H,y){var h=l("../utils/common"),q=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],d=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],n=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],r=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,
28,29,29,64,64];H.exports=function(u,m,x,f,k,t,C,w){var p=w.bits,v,g,F,G,I,K,c=0,N=new h.Buf16(16);var P=new h.Buf16(16);var a,B=0;for(v=0;15>=v;v++)N[v]=0;for(g=0;g<f;g++)N[m[x+g]]++;var e=p;for(F=15;1<=F&&0===N[F];F--);e>F&&(e=F);if(0===F)return k[t++]=20971520,k[t++]=20971520,w.bits=1,0;for(p=1;p<F&&0===N[p];p++);e<p&&(e=p);for(v=G=1;15>=v;v++)if(G<<=1,G-=N[v],0>G)return-1;if(0<G&&(0===u||1!==F))return-1;P[1]=0;for(v=1;15>v;v++)P[v+1]=P[v]+N[v];for(g=0;g<f;g++)0!==m[x+g]&&(C[P[m[x+g]]++]=g);if(0===
u){var A=a=C;var z=19}else 1===u?(A=q,c-=257,a=d,B-=257,z=256):(A=n,a=r,z=-1);g=I=0;v=p;var D=t;f=e;P=0;var T=-1;var L=1<<e;var X=L-1;if(1===u&&852<L||2===u&&592<L)return 1;for(;;){var O=v-P;if(C[g]<z){var b=0;var E=C[g]}else C[g]>z?(b=a[B+C[g]],E=A[c+C[g]]):(b=96,E=0);G=1<<v-P;p=K=1<<f;do K-=G,k[D+(I>>P)+K]=O<<24|b<<16|E|0;while(0!==K);for(G=1<<v-1;I&G;)G>>=1;0!==G?(I&=G-1,I+=G):I=0;g++;if(0===--N[v]){if(v===F)break;v=m[x+C[g]]}if(v>e&&(I&X)!==T){0===P&&(P=e);D+=p;f=v-P;for(G=1<<f;f+P<F;){G-=N[f+
P];if(0>=G)break;f++;G<<=1}L+=1<<f;if(1===u&&852<L||2===u&&592<L)return 1;T=I&X;k[T]=e<<24|f<<16|D-t|0}}0!==I&&(k[D+I]=v-P<<24|4194304);w.bits=e;return 0}},{"../utils/common":62}],72:[function(l,H,y){H.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],73:[function(l,H,y){function h(b){for(var E=b.length;0<=--E;)b[E]=0}function q(b,E,J,M,R){this.static_tree=b;this.extra_bits=
E;this.extra_base=J;this.elems=M;this.max_length=R;this.has_stree=b&&b.length}function d(b,E){this.dyn_tree=b;this.max_code=0;this.stat_desc=E}function n(b,E){b.pending_buf[b.pending++]=E&255;b.pending_buf[b.pending++]=E>>>8&255}function r(b,E,J){b.bi_valid>16-J?(b.bi_buf|=E<<b.bi_valid&65535,n(b,b.bi_buf),b.bi_buf=E>>16-b.bi_valid,b.bi_valid+=J-16):(b.bi_buf|=E<<b.bi_valid&65535,b.bi_valid+=J)}function u(b,E,J){r(b,J[2*E],J[2*E+1])}function m(b,E){var J=0;do J|=b&1,b>>>=1,J<<=1;while(0<--E);return J>>>
1}function x(b,E,J){var M=Array(16),R=0,S;for(S=1;15>=S;S++)M[S]=R=R+J[S-1]<<1;for(J=0;J<=E;J++)R=b[2*J+1],0!==R&&(b[2*J]=m(M[R]++,R))}function f(b){var E;for(E=0;286>E;E++)b.dyn_ltree[2*E]=0;for(E=0;30>E;E++)b.dyn_dtree[2*E]=0;for(E=0;19>E;E++)b.bl_tree[2*E]=0;b.dyn_ltree[512]=1;b.opt_len=b.static_len=0;b.last_lit=b.matches=0}function k(b){8<b.bi_valid?n(b,b.bi_buf):0<b.bi_valid&&(b.pending_buf[b.pending++]=b.bi_buf);b.bi_buf=0;b.bi_valid=0}function t(b,E,J,M){var R=2*E,S=2*J;return b[R]<b[S]||b[R]===
b[S]&&M[E]<=M[J]}function C(b,E,J){for(var M=b.heap[J],R=J<<1;R<=b.heap_len;){R<b.heap_len&&t(E,b.heap[R+1],b.heap[R],b.depth)&&R++;if(t(E,M,b.heap[R],b.depth))break;b.heap[J]=b.heap[R];J=R;R<<=1}b.heap[J]=M}function w(b,E,J){var M=0;if(0!==b.last_lit){do{var R=b.pending_buf[b.d_buf+2*M]<<8|b.pending_buf[b.d_buf+2*M+1];var S=b.pending_buf[b.l_buf+M];M++;if(0===R)u(b,S,E);else{var Q=A[S];u(b,Q+256+1,E);var U=K[Q];0!==U&&(S-=z[Q],r(b,S,U));R--;Q=256>R?e[R]:e[256+(R>>>7)];u(b,Q,J);U=c[Q];0!==U&&(R-=
D[Q],r(b,R,U))}}while(M<b.last_lit)}u(b,256,E)}function p(b,E){var J=E.dyn_tree,M=E.stat_desc.static_tree,R=E.stat_desc.has_stree,S=E.stat_desc.elems,Q,U=-1;b.heap_len=0;b.heap_max=573;for(Q=0;Q<S;Q++)0!==J[2*Q]?(b.heap[++b.heap_len]=U=Q,b.depth[Q]=0):J[2*Q+1]=0;for(;2>b.heap_len;){var V=b.heap[++b.heap_len]=2>U?++U:0;J[2*V]=1;b.depth[V]=0;b.opt_len--;R&&(b.static_len-=M[2*V+1])}E.max_code=U;for(Q=b.heap_len>>1;1<=Q;Q--)C(b,J,Q);V=S;do Q=b.heap[1],b.heap[1]=b.heap[b.heap_len--],C(b,J,1),M=b.heap[1],
b.heap[--b.heap_max]=Q,b.heap[--b.heap_max]=M,J[2*V]=J[2*Q]+J[2*M],b.depth[V]=(b.depth[Q]>=b.depth[M]?b.depth[Q]:b.depth[M])+1,J[2*Q+1]=J[2*M+1]=V,b.heap[1]=V++,C(b,J,1);while(2<=b.heap_len);b.heap[--b.heap_max]=b.heap[1];Q=E.dyn_tree;V=E.max_code;M=E.stat_desc.static_tree;R=E.stat_desc.has_stree;S=E.stat_desc.extra_bits;var Y=E.stat_desc.extra_base,aa=E.stat_desc.max_length,W,ba=0;for(W=0;15>=W;W++)b.bl_count[W]=0;Q[2*b.heap[b.heap_max]+1]=0;for(E=b.heap_max+1;573>E;E++){var Z=b.heap[E];W=Q[2*Q[2*
Z+1]+1]+1;W>aa&&(W=aa,ba++);Q[2*Z+1]=W;if(!(Z>V)){b.bl_count[W]++;var da=0;Z>=Y&&(da=S[Z-Y]);var ea=Q[2*Z];b.opt_len+=ea*(W+da);R&&(b.static_len+=ea*(M[2*Z+1]+da))}}if(0!==ba){do{for(W=aa-1;0===b.bl_count[W];)W--;b.bl_count[W]--;b.bl_count[W+1]+=2;b.bl_count[aa]--;ba-=2}while(0<ba);for(W=aa;0!==W;W--)for(Z=b.bl_count[W];0!==Z;)M=b.heap[--E],M>V||(Q[2*M+1]!==W&&(b.opt_len+=(W-Q[2*M+1])*Q[2*M],Q[2*M+1]=W),Z--)}x(J,U,b.bl_count)}function v(b,E,J){var M,R=-1,S=E[1],Q=0,U=7,V=4;0===S&&(U=138,V=3);E[2*
(J+1)+1]=65535;for(M=0;M<=J;M++){var Y=S;S=E[2*(M+1)+1];++Q<U&&Y===S||(Q<V?b.bl_tree[2*Y]+=Q:0!==Y?(Y!==R&&b.bl_tree[2*Y]++,b.bl_tree[32]++):10>=Q?b.bl_tree[34]++:b.bl_tree[36]++,Q=0,R=Y,0===S?(U=138,V=3):Y===S?(U=6,V=3):(U=7,V=4))}}function g(b,E,J){var M,R=-1,S=E[1],Q=0,U=7,V=4;0===S&&(U=138,V=3);for(M=0;M<=J;M++){var Y=S;S=E[2*(M+1)+1];if(!(++Q<U&&Y===S)){if(Q<V){do u(b,Y,b.bl_tree);while(0!==--Q)}else 0!==Y?(Y!==R&&(u(b,Y,b.bl_tree),Q--),u(b,16,b.bl_tree),r(b,Q-3,2)):10>=Q?(u(b,17,b.bl_tree),
r(b,Q-3,3)):(u(b,18,b.bl_tree),r(b,Q-11,7));Q=0;R=Y;0===S?(U=138,V=3):Y===S?(U=6,V=3):(U=7,V=4)}}}function F(b){var E=4093624447,J;for(J=0;31>=J;J++,E>>>=1)if(E&1&&0!==b.dyn_ltree[2*J])return 0;if(0!==b.dyn_ltree[18]||0!==b.dyn_ltree[20]||0!==b.dyn_ltree[26])return 1;for(J=32;256>J;J++)if(0!==b.dyn_ltree[2*J])return 1;return 0}function G(b,E,J,M){r(b,M?1:0,3);k(b);n(b,J);n(b,~J);I.arraySet(b.pending_buf,b.window,E,J,b.pending);b.pending+=J}var I=l("../utils/common"),K=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,
2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],c=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],N=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],P=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],a=Array(576);h(a);var B=Array(60);h(B);var e=Array(512);h(e);var A=Array(256);h(A);var z=Array(29);h(z);var D=Array(30);h(D);var T,L,X,O=!1;y._tr_init=function(b){if(!O){var E,J,M,R=Array(16);for(M=J=0;28>M;M++)for(z[M]=J,E=0;E<1<<K[M];E++)A[J++]=M;A[J-1]=M;for(M=J=0;16>M;M++)for(D[M]=J,E=0;E<1<<c[M];E++)e[J++]=
M;for(J>>=7;30>M;M++)for(D[M]=J<<7,E=0;E<1<<c[M]-7;E++)e[256+J++]=M;for(E=0;15>=E;E++)R[E]=0;for(E=0;143>=E;)a[2*E+1]=8,E++,R[8]++;for(;255>=E;)a[2*E+1]=9,E++,R[9]++;for(;279>=E;)a[2*E+1]=7,E++,R[7]++;for(;287>=E;)a[2*E+1]=8,E++,R[8]++;x(a,287,R);for(E=0;30>E;E++)B[2*E+1]=5,B[2*E]=m(E,5);T=new q(a,K,257,286,15);L=new q(B,c,0,30,15);X=new q([],N,0,19,7);O=!0}b.l_desc=new d(b.dyn_ltree,T);b.d_desc=new d(b.dyn_dtree,L);b.bl_desc=new d(b.bl_tree,X);b.bi_buf=0;b.bi_valid=0;f(b)};y._tr_stored_block=G;y._tr_flush_block=
function(b,E,J,M){var R=0;if(0<b.level){2===b.strm.data_type&&(b.strm.data_type=F(b));p(b,b.l_desc);p(b,b.d_desc);v(b,b.dyn_ltree,b.l_desc.max_code);v(b,b.dyn_dtree,b.d_desc.max_code);p(b,b.bl_desc);for(R=18;3<=R&&0===b.bl_tree[2*P[R]+1];R--);b.opt_len+=3*(R+1)+14;var S=b.opt_len+3+7>>>3;var Q=b.static_len+3+7>>>3;Q<=S&&(S=Q)}else S=Q=J+5;if(J+4<=S&&-1!==E)G(b,E,J,M);else if(4===b.strategy||Q===S)r(b,2+(M?1:0),3),w(b,a,B);else{r(b,4+(M?1:0),3);E=b.l_desc.max_code+1;J=b.d_desc.max_code+1;R+=1;r(b,
E-257,5);r(b,J-1,5);r(b,R-4,4);for(S=0;S<R;S++)r(b,b.bl_tree[2*P[S]+1],3);g(b,b.dyn_ltree,E-1);g(b,b.dyn_dtree,J-1);w(b,b.dyn_ltree,b.dyn_dtree)}f(b);M&&k(b)};y._tr_tally=function(b,E,J){b.pending_buf[b.d_buf+2*b.last_lit]=E>>>8&255;b.pending_buf[b.d_buf+2*b.last_lit+1]=E&255;b.pending_buf[b.l_buf+b.last_lit]=J&255;b.last_lit++;0===E?b.dyn_ltree[2*J]++:(b.matches++,E--,b.dyn_ltree[2*(A[J]+256+1)]++,b.dyn_dtree[2*(256>E?e[E]:e[256+(E>>>7)])]++);return b.last_lit===b.lit_bufsize-1};y._tr_align=function(b){r(b,
2,3);u(b,256,a);16===b.bi_valid?(n(b,b.bi_buf),b.bi_buf=0,b.bi_valid=0):8<=b.bi_valid&&(b.pending_buf[b.pending++]=b.bi_buf&255,b.bi_buf>>=8,b.bi_valid-=8)}},{"../utils/common":62}],74:[function(l,H,y){H.exports=function(){this.input=null;this.total_in=this.avail_in=this.next_in=0;this.output=null;this.total_out=this.avail_out=this.next_out=0;this.msg="";this.state=null;this.data_type=2;this.adler=0}},{}]},{},[10])(10)});
